* racd01.do  January 2013 for Stata version 12

capture log close
log using racd01.txt, text replace

********** OVERVIEW OF racd01.do **********

* STATA Program 
* copyright C 2013 by A. Colin Cameron and Pravin K. Trivedi 
* used for "Regression Analyis of Count Data" Second Edition
* by A. Colin Cameron and Pravin K. Trivedi (2013)
* Cambridge University Press

* Chapter 1
*   1.3 EXAMPLES

* To run you need files
*   racd01asthma.data
*   racd03data.dta  health
*   racd06data2rectrips.dta
*   racd06data4fertilitybritish.dta

********** SETUP **********

set more off
version 12
clear all
set linesize 82
set scheme s1mono  /* Graphics scheme */

********** DATA DESCRIPTION ************

* The dataset racd01asthma.data is from 
* R.A. Davis, W.T.M. Dunsmuir and S.B. Streett (2003),
* "On autocorrelation in a Poisson regression model," Biometrika 87, 491-506.

* The dataset racd03data.dta is from
* A.C. Cameron and P.K. Trivedi (1986), "Econometric Models Based on
* Count Data: Comparisons and Applications of  Some Estimators and Tests",
* Journal of Applied Econometrics, Vol. 1, pp. 29-54.

* The data in racd06data2rectrips.dta are from 
* C. Sellar, J.R. Stoll and J.P. Chavas (1985), "Validation of Empirical
* Measures of Welfare Change: A Comparison of nonmarket Techniques," 
* Land Economics, 61, 156-175.  
* Data used with permission of Sellar et al. (1985)

* The data in racd06data4fertilitybritish.dta are authors own data.

********** 1.3 EXAMPLES: Create Figures 1.1 and 1.2

use racd03data.dta, clear
sum DVISITS
di "Mean: " r(mean) "  Variance: " r(Var)
label variable DVISITS "Number of doctor visits"
histogram DVISITS, discrete frequency barwidth(0.8) saving(racd01graph1, replace) xlabel(#6)

clear 
set obs 5190
generate xpoisson = rpoisson(0.3)
sum xpoisson
di "Mean: " r(mean) "  Variance: " r(Var)
label variable xpoisson "Generated Poisson with mean 0.3"
histogram xpoisson, discrete frequency barwidth(0.8) saving(racd01graph2, replace) xlabel(#6)

use racd06data2rectrips.dta, clear
sum TRIPS
di "Mean: " r(mean) "  Variance: " r(Var)
label variable TRIPS "Number of recreational trips"
histogram TRIPS if TRIPS < 15, discrete frequency barwidth(0.8) saving(racd01graph3, replace) xlabel(#6)

use racd06data4fertilitybritish.dta, clear
sum children
di "Mean: " r(mean) "  Variance: " r(Var)
label variable children "Number of children"
histogram children, discrete frequency barwidth(0.8) saving(racd01graph4, replace) xlabel(#6)

*** FIGURE 1.1: FOUR HISTOGRAMS

graph combine racd01graph1.gph racd01graph2.gph racd01graph3.gph racd01graph4.gph, ///
   iscale(0.7) ysize(5) xsize(6) xcommon rows(2)

graph export racd01fig1.eps, replace
graph export racd01fig1.wmf, replace

use racd01asthmadata.dta, clear
sum
sum campbelltown
di "Mean: " r(mean) "  Variance: " r(Var)
label variable campbelltown "Admissions for asthma"
label variable time "Day"

histogram campbelltown, discrete frequency barwidth(0.8) saving(racd01graph5, replace) xlabel(#6)

tsline campbelltown if time < 100, saving(racd01graph6, replace) xlabel(#6) 

ac campbelltown, saving(racd01graph7, replace) lags(20) note(" ") xlabel(#6) ///
 ciopts(fintensity(inten10)) ytitle("Autocorrelations of asthma admissions")

generate sqcampbelltown = campbelltown^2
ac sqcampbelltown, saving(racd01graph8, replace) lags(20) note(" ") xlabel(#6) ///
 ciopts(fintensity(inten10)) ytitle("Autocorrelations of squared asthma")

** FIGURE 1.2: ASTHMA DATA

graph combine racd01graph5.gph racd01graph6.gph racd01graph7.gph racd01graph8.gph, ///
   iscale(0.7) ysize(5) xsize(6) rows(2)

graph export racd01fig2.eps, replace
graph export racd01fig2.wmf, replace

********** CLOSE OUTPUT

* log close
* clear
* exit

