# racd09.R  March 2012 for R version 2.15.0

# Create log file
sink("racd09.Rout")

rm(list=ls())

# ********** OVERVIEW OF racd09.R **********

# R Program 
# copyright C 2012 by A. Colin Cameron and Pravin K. Trivedi 
# used for "Regression Analyis of Count Data" SECOND EDITION
# by A. Colin Cameron and Pravin K. Trivedi (2012)
# Cambridge University Press

# To run you need file
#   racd10data.dta
# and R packages
#   foreign, sandwich

# This R program reads in data and runs Poisson for chapter 9 patents data
# The Stata program racd09.do does much more
#  9.4.5 PATENTS DATA
 
# ********* DATA DESCRIPTION

#  The original data are from 
#  Bronwyn Hall, Zvi Griliches, and Jerry Hausman (1986), 
#  "Patents and R&D: Is There a Lag?", 
#  International Economic Review, 27, 265-283.
#  See this article for more detailed discussion 
#  Also see racd09makedata.do for further details  

# ********* 10.5 PATENTS: First column of Table 9.2

install.packages("foreign")
library(foreign)
data.ch09 <- read.dta(file = "racd09data.dta")
# Allows variables in database to be accessed simply by giving names
attach(data.ch09)

# Lists first six observations
head(data.ch09)

# Tabulate counts of doctor visits
table(PAT)
table(PAT) / nrow(data.ch09)

# Variable list
names(data.ch09)

# Summary statistics
summary(data.ch09)
sapply(data.ch09,mean)
sapply(data.ch09,sd)

# Formula for the model estimated in this chapter - shortens the commands below
formula.ch09model <- as.formula(PAT ~ LOGR+LOGR1+LOGR2+LOGR3+LOGR4+LOGR5+LOGK+SCISECT+dyear2+dyear3+dyear4+dyear5)

# Poisson with default standard errors (variance is a multiple of the mean)
model.poiss <- glm(formula.ch09model, family=poisson()) 
summary(model.poiss)

### First column of Table 9.2 for coefficients but not standard errors
### The standard errors here are heteroskedastic robust but not cluster robust

# Poisson with robust standard errors (no assumption on variance)
# install.packages("sandwich")
library(sandwich)
cov.robust <- vcovHC (model.poiss, type="HC0")
se.robust <- sqrt(diag(cov.robust))
coeffs <- coef(model.poiss)
t.robust <- coeffs / se.robust
summary.poissrobust <- cbind(coeffs, se.robust, t.robust, pvalue=round(2*(1-pnorm(abs(coeffs/se.robust))),5), 
           lower=coeffs-1.96*se.robust, upper=coeffs+1.96*se.robust)    
print(summary.poissrobust,digits=3)

# close log file
sink()
