% This is the first code of a set that constructs the matrices (Hessians)
% necessary to implement the LQ solution of Benigno and Woodford (NBER
% November, 2006, equation 2.19)
% This code retrieves the model and returns the indeces of the will be
% Lagrange's multipliers of forward-looking equations and backward-looking
% equations
% Syntax: lq_1_get_mod name_of_mod_file Util Welf policy_id lagr_name ext_ss extension
% where Util is the name of the objective function variable
%       Welf is the Welfare definitio (as used in get_ramsey)
%       policy_id is the name of the parameter used to identify the policy
%       equations (i.e. in the policy rule you must enter a parameter e.g.
%       poly that is unique to the policy rules: example
%       R=rho*R(-1)+lambda*pi(+1)+poly; This parameter will have value zero
%       in the parameter values;
%       lagr_name= name to be given to the lagrange multipliers
%       Extension= string to append to filename of new mod file (and
%       associated LQ matrices (default = _lq);
% ext_ss= if in the model ss_variables are used eg. C_ss or Cbar must
%       give _ss or bar etc.
% Also it rebuilds the mod file following the convention in Benigno
% Woodford LQ approach that fwd-looking equations don't have lagged
% variables.
% It constructs the FOC for the ramsey problem in order to get the stst
% lagrange multipliers
% It also computes the second order derivatives to obtain the BW eq. 2.19
% LQ welfare.
% Giovanni Lombardo, ECB, January 2007
function varargout=OPDSGE(varargin)
warning off
%preamble on generating a copy of the mod file in BW notation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if isempty(varargin)
    disp('You can write directly >> lq_1_get_mod namefile name_utility name_welfare')
    disp('____________________________________________________')
    fname=input('Give name of .mod file ','s');
    utilstr=input('Give name of objective function ','s');
    welfstr=input('Give name of welfare function ','s');
    pol_id=input('Give parameter that identifies policy equation (this must appear only in the policy equation):  ','s');
    namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
    ext_ss=input('Give steady state string (e.g. _ss BAR etc.) >>','s');
    lq_string=input('Give extention of namefile (default=_lq)','s');
    smb=input('Symbolic LQ matrices? (yes=1,no=0)>> ');
    if isempty(lq_string);
        lq_string='_lq';
    end
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');
elseif nargin==1
    fname=varargin{1};
    utilstr=input('Give name of objective function ','s');
    
    welfstr=input('Give name of welfare function ','s');
    pol_id=input('Give parameter that identifies policy equation (this must appear only in the policy equation):  ','s');
    namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
    ext_ss=input('Give steady state string (e.g. _ss BAR etc.) >>','s');
    lq_string=input('Give extention of namefile (default=_lq)','s');
    smb=input('Symbolic LQ matrices? (yes=1,no=0)>> ');
    
    if isempty(lq_string);
        lq_string='_lq';
    end
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');
elseif nargin==2
    fname=varargin{1};
    utilstr=varargin{2};
    welfstr=input('Give name of welfare function ','s');
    pol_id=input('Give parameter that identifies policy equation (this must appear only in the policy equation):  ','s');
    namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
    ext_ss=input('Give steady state string (e.g. _ss BAR etc.) >>','s');
    lq_string=input('Give extention of namefile (default=_lq)','s');
    smb=input('Symbolic LQ matrices? (yes=1,no=0)>> ');
    
    if isempty(lq_string);
        lq_string='_lq';
    end
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');
elseif nargin==3
    fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=input('Give parameter that identifies policy equation (this must appear only in the policy equation):  ','s');
    namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
    ext_ss=input('Give steady state string (e.g. _ss BAR etc.) >>','s');
    lq_string=input('Give extention of namefile (default=_lq)','s');
    smb=input('Symbolic LQ matrices? (yes=1,no=0)>> ');
    
    if isempty(lq_string);
        lq_string='_lq';
    end
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');
    
elseif nargin==4
    fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=varargin{4};
    namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
    ext_ss=input('Give steady state string (e.g. _ss BAR etc.) >>','s');
    lq_string=input('Give extention of namefile (default=_lq)','s');
    smb=input('Symbolic LQ matrices? (yes=1,no=0)>> ');
    
    if isempty(lq_string);
        lq_string='_lq';
    end
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');
elseif nargin==5
    fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=varargin{4};
    namelagr=varargin{5};
    ext_ss=input('Give steady state string (e.g. _ss BAR etc.) >>','s');
    lq_string=input('Give extention of namefile (default=_lq)','s');
    smb=input('Symbolic LQ matrices? (yes=1,no=0)>> ');
    
    if isempty(lq_string);
        lq_string='_lq';
    end
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');

elseif nargin==6
    fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=varargin{4};
    namelagr=varargin{5};
    ext_ss=varargin{6};
    smb=input('Symbolic LQ matrices? (yes=1,no=0)>> ');
    
    lq_string='_lq';
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');
elseif nargin==7
    fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=varargin{4};
    namelagr=varargin{5};
    ext_ss=varargin{6};
    lq_string=varargin{7};
    smb=input('Symbolic LQ matrices? (yes=1,no=0)>> ');
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');
elseif nargin==8
    fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=varargin{4};
    namelagr=varargin{5};
    ext_ss=varargin{6};
    lq_string=varargin{7};
    smb=str2num(varargin{8});
    nash=input('Compute Nash solution? (yes=1,no=0(default)) ');
elseif nargin==9
    fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=varargin{4};
    namelagr=varargin{5};
    ext_ss=varargin{6};
    lq_string=varargin{7};
    smb=str2num(varargin{8});
    nash=str2num(varargin{9});
    if nash==1;disp('COMPUTING NASH EQUILIBRIUM');end
end

ysoc=input('DO YOU NEED SOCs TOO? (0/1) ==> ');
soc=[];
soc_ss=[];
namemodN=regexp(fname,'\.');
if isempty(namemodN)
    namemodN=length(fname)+1;
    fname=strcat(fname,'.mod');
end
if ~exist(fname,'file');
    disp(['The file <', fname ,'> could not be found in the current directory']);
    return
end
namemod=fname(1:namemodN-1);



modfile=(textread(fname,'%s','bufsize',1000000,'whitespace','\n'));%,






% search for string 'model' that appears as first non-commented string;


[modstrt,tmpst]= find_incell(modfile,'^model|(?<!(\S\s*))(model)');

% variables


[xx,vars]= find_incell(modfile(1:modstrt,:),'^var\>|(?<!(\S\s*))(var\>)');

[xx,endvars]= find_incell(modfile(1:modstrt,:),';');
endvars=endvars(endvars>=vars(1));
endings=[];
for jj=1:size(vars,1)
    endings(jj,1)=min(endvars(endvars>=vars(jj)));
end

vary=[];
for jj=1:size(vars,1);
    vary{jj,1}=char(regexprep((strread(char(modfile(vars(jj):endings(jj),:))','%s','delimiter',';')),'\<var\>',''));
    vary{jj,1}=eval([,'{''',regexprep(vary{jj,1},',',''','''),'''}']);
end
tmpv=[];
for jj=1:size(vary,1);
    tmp=(vary{jj}(:,:));
    for kk=1:max(size(tmp))
        tmpv{end+1,1}=regexprep(tmp{kk},'\s+','');
    end
end
vary=tmpv;
if size(tmpst,1)>1
    disp('the word ''model'' appears more than once and in a conflicting way in lines')
    disp(tmpst')
    disp('Reserve the word ''model'' for the declarationo of the model and run <mod_red> again');
    return
end

[modend,tmpst]= find_incell(modfile,'^end|(?<!(\S\s*))(end)');
model=modfile(modstrt+1:modend-1,:);
%  keyboard
[shocks_strt,shocks]= find_incell(model,'(?<=(\s*\/\/\s*\w*\s+))(shocks)','ignorecase');
if isempty(shocks_strt)
    disp('Must indicate the beginning of the block of exogenous shocks');
    return
end
shock_block=model(shocks_strt:end,:);
model=model([1:shocks_strt],:);
% find exogenous variables
ex_var=[];
zz=1;
[xx,commented_line]=find_incell(shock_block,'(?<!(.\s*))(\/\/)');
idx=setdiff([1:size(shock_block,1)]',commented_line);
tmp_shock_block=shock_block(idx,:);

for jj=1:size(vary,1);
    
    tmp=((find_incell(tmp_shock_block,['(?<!\w)',vary{jj},'[\s*\+\-\(\)\/\*\^\=;]'])));
    if ~isempty(tmp)
        ex_var{zz,1}=(vary{jj});
        zz=zz+1;
    end
end
if isempty(ex_var);
    disp('Could not identify the equations block of the shocks');
    return
end
% keyboard
vary=setdiff(vary,ex_var);

%% get rid of commented blocks
% save in temp file
fid=fopen('temp.m','w');
fclose(fid);
fopen('temp.m','a+');
for jj=1:size(model,1);
    fprintf(fid,'%s\n',[model{jj}]);
end
fclose(fid);
% keyboard

model=(textread('temp.m','%c','bufsize',1000000,'whitespace','\n','commentstyle','c++'));
model=(strread(model','%s','delimiter',';'));
delete temp.m


tmp1=['(?<![\w0-9])(',deblank(utilstr),')(?![\w0-9])'];%gianni 30.Oct.08
[xx,util]=find_incell(model,tmp1);
obj_fnc=model(xx,:);

tmp2=['(?<!\W)(',deblank(welfstr),'\>)'];

[xx,welf]=find_incell(model,tmp2);

welf_fnc=model(xx,:);

tmp3=['(?<!\w)(',deblank(pol_id),'\)*\>)'];

[xx,policy]=find_incell(model,tmp3);
if ~isempty(policy)
    fprintf('Found %10.0f Policy Rules\n',length(policy));
    fprintf('COMPUTING THE OPTIMAL POLICY\n');
end
policy_eq=model(policy,:);

utilwelfpoly=[util;welf;policy];

nowelf=setdiff([1:size(model,1)]',utilwelfpoly);
model=model(nowelf,:);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% turn rest of model (i.e. constraints) into lhs expressions: in this way apply convention that
% rhs terms are subtracted from lhs terms: hence preserving sign of
% constraints in computing LQ solution
tmp_mod=[];
for jj=1:size(model,1);
    xx=regexp(model{jj},'\=');
    if ~isempty(xx)
        tmp_1=regexp(model{jj},'(?<=\=).*','match');
        tmp_2=regexp(model{jj},'.*(?=\=)','match');
        model{jj}=[char(tmp_2),'-(',char(tmp_1),')=0'];
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[xx,fwd_eq]=find_incell(model,'(?<![\^ \+ \- \/ \* \(])\(\+[1-9]*\)');

% check if there are lags in fwd_eq: if so generate dummy variables:

mod_fwd=model(fwd_eq,:);

new_block=[];
newvars=[];
new_ss_block=[];
z=1;
for jj=1:size(mod_fwd,1);
    [xx]=regexp(mod_fwd{jj},'([a-zA-Z1-9\_]+\(\-[1-9]*\))','match');
    
    if ~isempty(xx)
        for kk=1:size(xx',1)
            uu=regexp(char(xx{kk}),'([a-zA-Z1-9\_]*)(?=(\(\-[1-9]*\)))','match');
            nuu=regexprep(char(xx{kk}),'[a-zA-Z1-9\_]*(?=\((\-[1-9]*\)))','');
            nuu=regexprep(nuu,'[\(\)\-]','');
            tmp=['dummy_lq_',char(uu),'_',char(nuu)];

            % keyboard
            newvars{z,1}=tmp;
            
            new_block{z,1}=[tmp,'-(',char(xx{kk}),')=0'];
            new_ss_block{z,1}=[tmp,'=',regexprep(char(xx{kk}),'(\-[1-9]*\)',''),';'];
            tmp2=regexprep(char(xx{kk}),'\(','\\(');
            tmp2=regexprep(tmp2,'\)','\\)');
            tmp2=regexprep(tmp2,'\-','\\-');
            tmp2=regexprep(tmp2,'\_','\\_');
            xx{kk}=tmp2;
            tmp=regexprep(tmp,'\_','\\_');
            
            mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)(',xx{kk},')'],tmp);
            z=z+1;
        end
    end
end


if 0
    %%% eliminate leads of exogenous shocks: why?: to be able to lag variables
    %%% in FOC of forward looking block?
    
    
    dd=[];
    for jj=1:size(ex_var,1)-1;
        dd=[dd,'(',regexprep(deblank(ex_var{jj}),'\_','\\_'),')\(\+[1-9]*\)|'];
    end
    dd=[dd,'(',regexprep(deblank(ex_var{jj+1}),'\_','\\_'),')\(\+[1-9]*\)'];
    % shouldn't do the following for shocks
    % keyboard
    for jj=1:size(mod_fwd,1);
        [xx]=regexp(mod_fwd{jj},[dd],'match');%,'\(\+[1-9]*\)'
        
        if ~isempty(xx) %leading shocks
            for kk=1:size(xx',1)
                uu=regexp(char(xx{kk}),'([a-zA-Z1-9\_]*)(?=(\(\+[1-9]*\)))','match');
                nuu=regexp(char(xx{kk}),'\(\+[1-9]*\)','match');
                indx=regexprep(nuu,'\(','\\(');
                indx=regexprep(indx,'\)','\\)');
                indx=regexprep(indx,'\+','\\+');
                nuu=regexprep(nuu,'[\(\)]','');
                nuu=regexprep(nuu,'\+','pl');
                tmp=['dummy_lq_',char(uu),'_',char(nuu)];
                newvars{z,1}=tmp;
                
                new_block{z,1}=[tmp,'-(',regexprep(char(xx{kk}),'\(\+[1-9]*\)',''),')=0'];
                new_ss_block{z,1}=[tmp,'=',regexprep(char(xx{kk}),'(\+[1-9]*\)',''),';'];
                tmp2=regexprep(char(xx{kk}),'\(','\\(');
                tmp2=regexprep(tmp2,'\)','\\)');
                tmp2=regexprep(tmp2,'\-','\\-');
                tmp2=regexprep(tmp2,'\_','\\_');
                tmp2=regexprep(tmp2,'\+','\\+');
                xx{kk}=tmp2;
                tmp=[regexprep(tmp,'\_','\\_'),char(indx)];
                
                mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)(',xx{kk},')'],tmp);
                z=z+1;
                
            end
        end
    end
    
end %lead shocks

%%%% eliminate leads-lags from objective and generate dummies instead
%  keyboard
if isempty(obj_fnc);
    error('NO OBJECTIVE FUNCTION (UTIL) FOUND IN MODEL');
end
[xx]=regexp(obj_fnc{1},'[a-zA-Z1-9\_]*\(\-[1-9]*\)','match');

if ~isempty(xx)
    for kk=1:size(xx',1)
        uu=regexp(char(xx{kk}),'([a-zA-Z1-9\_]*)(?=(\(\-[1-9]*\)))','match');
        nuu=regexprep(char(xx{kk}),'[a-zA-Z1-9\_]*(?=\((\-[1-9]*\)))','');
        nuu=regexprep(nuu,'[\(\)\-]','');
        if isempty(find_incell(ex_var,deblank(char(uu))));
            tmp=['dummy_lq_',char(uu),'_',char(nuu)];
            newvars{z,1}=tmp;
            
            new_block{z,1}=[tmp,'-(',char(xx{kk}),')=0'];
            new_ss_block{z,1}=[tmp,'=',regexprep(char(xx{kk}),'(\-[1-9]*\)',''),';'];
            tmp2=regexprep(char(xx{kk}),'\(','\\(');
            tmp2=regexprep(tmp2,'\)','\\)');
            tmp2=regexprep(tmp2,'\-','\\-');
            tmp2=regexprep(tmp2,'\_','\\_');
            xx{kk}=tmp2;
            tmp=regexprep(tmp,'\_','\\_');
            
            obj_fnc=regexprep(obj_fnc,['(?<!\w)(',xx{kk},')'],tmp);
            z=z+1;
        end % if no shocks 29 jan 2010
    end
end
%%% and leads
new_fwd_block=[];
w=1;
[xx]=regexp(obj_fnc{1},'[a-zA-Z1-9\_]*\(\+[1-9]*\)','match');

if ~isempty(xx)
    for kk=1:size(xx',1)
        uu=regexp(char(xx{kk}),'([a-zA-Z1-9\_]*)(?=(\(\+[1-9]*\)))','match');
        nuu=regexprep(char(xx{kk}),'[a-zA-Z1-9\_]*(?=\((\+[1-9]*\)))','');
        nuu=regexprep(nuu,'[\(\)]','');
        nuu=regexprep(nuu,'\+','pl');
        if isempty(find_incell(ex_var,deblank(char(uu))));
            tmp=['dummy_lq_',char(uu),'_',char(nuu)];
            newvars{z,1}=tmp;
            
            new_fwd_block{w,1}=[tmp,'-(',char(xx{kk}),')=0'];
            new_ss_block{z,1}=[tmp,'=',regexprep(char(xx{kk}),'(\+[1-9]*\)',''),';'];
            tmp2=regexprep(char(xx{kk}),'\(','\\(');
            tmp2=regexprep(tmp2,'\)','\\)');
            tmp2=regexprep(tmp2,'\-','\\-');
            tmp2=regexprep(tmp2,'\_','\\_');
            xx{kk}=tmp2;
            tmp=regexprep(tmp,'\_','\\_');
            
            obj_fnc=regexprep(obj_fnc{1},['(?<!\w)(',xx{kk},')'],tmp);
            z=z+1;
            w=w+1;
        end % if shocks 29 jan 2010
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
new_ss_block=unique(new_ss_block);
new_block=unique(new_block);
new_fwd_block=unique(new_fwd_block);
newvars=unique(newvars);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
bwd_eq=setdiff([1:size(model,1)]',fwd_eq);
mod_bwd=model(bwd_eq,:);
%szmb=size(mod_bwd,1);
for jj=1:size(new_block,1);
    mod_bwd{end+1,1}=new_block{jj};
end
%%
%szmf=size(mod_fwd,1);
for jj=1:size(new_fwd_block,1);
    mod_fwd{end+1}=new_fwd_block{jj};
end
%





% all endogenous
tmpvar=vary;
vary=regexprep(vary,['(\<',deblank(utilstr),'\>)|(\<',deblank(welfstr),'\>)'],'');
vary=strvcat(vary);
vary=str2cell(vary);
uu=vary;

for jj=1:size(newvars,1);
    uu{end+1,1}=newvars{jj};
end

% keyboard
vary=uu;


% order variables alphabetically
[a,srt_end]=sortrows(lower(vary));
vary=vary(srt_end,:);
[a,srt_ex]=sortrows(lower(ex_var));
ex_var=ex_var(srt_ex,:);


%%%%%%%%%%%%%%%%%%%%%%% Generate First order conditions if optimal policy
%%%%%%%%%%%%%%%%%%%%%%% problem
% keyboard
weigh_h=[];
weigh_f=[];
lagnam=[];
if ~isempty(policy)
    
    % keyboard
    if nash==1
        
        home_inst=input('1) Give name of home instrument (e.g. pi) >> ','s');
        foreign_inst=input('2) Give name of foreign instrument (e.g. pi_s) >> ','s');
        weigh_h=input('3) Give name of home weight in home welfare >> ','s');
        weigh_f=input('4) Give name of foreign weight in foreign welfare >> ','s');
        xh=find_incell(vary,['\<',deblank(home_inst),'\>']);
        if isempty(xh);error('No home instrument found in variables set');end
        xf=find_incell(vary,['\<',deblank(foreign_inst),'\>']);
        if isempty(xf);error('No foreign instrument found in variables set');end
        gg=setdiff([1:size(vary,1)]',[xh;xf]);
        tmp_vary=vary(gg,:);
        tmp_vary{end+1,1}=vary{[xh]};
        tmp_vary{end+1,1}=vary{[xf]};
        vary=tmp_vary;
        clear tmp_vary;
        
        
    end % if nash
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% GENERATE LAGRANGE MULTIPLIERS NAMES AND
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% VARIABLES AT DIFFERENT TIME
    
    for jj=1:size(mod_bwd,1)+size(mod_fwd,1);
        lagnam{jj,1}=[deblank(namelagr),num2str(jj)];
    end
    
    %%%%%%%%%%%%%%%%%%% transform numerical subscripts into strings
    fwmod=dyn2mine(mod_fwd,5);
    bwmod=dyn2mine(mod_bwd,5);
    umod=dyn2mine(obj_fnc,5);
    
%% without jacobian
%     [foc]=lq_lagrange_problem(umod,bwmod,fwmod,vary,ex_var,lagnam);
%% with jaconian (faster)
[foc]=lq_lagrange_problem_jacobian(umod,bwmod,fwmod,vary,ex_var,lagnam,[namemod,'_',lq_string]);
if ysoc==1
[soc,soc_T0]=lq_lagrange_problem_hessian(umod,bwmod,fwmod,vary,ex_var,lagnam);
else
    soc=[];
    soc_T0=[];
end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% NASH
    if nash==1
        lagnam_for=[namelagr,'_foreign'];
        foc_f=regexprep(foc([1:end-2,end],:),namelagr,lagnam_for);
        
        foc_f=regexprep(foc_f,weigh_h,'nash_param');
        foc_h=regexprep(foc([1:end-1],:),weigh_f,'nash_param');
        for jj=1:size(lagnam,1);
            
            lagnam{end+1}=[deblank(lagnam_for),num2str(jj)];
        end
        foc=[];
        for jj=1:size(foc_h,1);
            foc{jj,1}=foc_h{jj};
        end
        for jj=1:size(foc_f,1)-1;
            foc{end+1,:}=['nash_param*(',[namelagr,'_foreign'],num2str(jj),'-',[namelagr],num2str(jj),')+(1-nash_param)*(',foc_f{jj},')'];
        end
        foc{end+1,:}=['nash_param*(',regexprep(foc_f{end},[namelagr,'\_foreign'],[namelagr]),')+(1-nash_param)*(',foc_f{end} ,')'];
        
    end
    
    
else
    foc=[];%{''};
end

% get the foc out
% copy from Matrix thing
% keyboard
%%%%%%%%%%%%%%%%%%%%%%%%%%%% SAVE MOD FILE
if ~isempty(foc)
    lq_get_costate_ss([namemod,'_',lq_string],foc,lagnam,ext_ss);
    foc=mine2dyn(foc,2);
    lq_get_costate_problem([namemod,'_',lq_string],ext_ss,umod,bwmod,fwmod,vary,smb);%(namemod,'',ext_ss)
    
end
if ~isempty(soc)
    % steady state version 
    soc_ss=regexprep(soc,'\_plus1|\_minus1','');
    % dynare dynamic version
     soc=mine2dyn(soc,2);
   
end
%% SAVING TO FILE BLOCK
[lq_name]=lq_save_lq_mod(namemod,lq_string,tmpvar,modfile,vars,endings,newvars,...
    ex_var,lagnam,namelagr,modstrt,modend,obj_fnc,welf_fnc,policy_eq,mod_bwd,mod_fwd,...
    foc,soc,soc_ss,shock_block,new_ss_block,vary);


%%

namemod=[lq_name];
% keyboard
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

szf=size(mod_fwd,1);

eval(['save ',[namemod,'_variables.mat vary ex_var lq_string namelagr lagnam szf nash weigh_f weigh_h -MAT']]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%LQ matrices only for optimal problem
if ~isempty(policy)
    
    eval(['save ',[namemod,'_info_4_lagr.mat vary ex_var lq_string fwmod bwmod umod  nash weigh_f weigh_h -MAT']]);
    
    %%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % generate fwd and bwd variables
    %%
    disp('------------------------------------------------------')
    lq=input('Need to generate matrices for LQ evaluation (1/0,default=0) >>');
    if lq~=0
        disp('------------------------------------------------------')
        tmp_f=[];
        for jj=1:size(vary,1);
            tmp_f{jj,1}=[deblank(vary{jj}),'_plus1'];
            
        end
        tmp_b=[];
        for jj=1:size(vary,1);
            tmp_b{jj,1}=[deblank(vary{jj}),'_minus1'];
            
        end
        
        %%%%%%%%%%%%%%%%%%%%%%%%% HESSIAN STUFF
        % ss_str='\_ss';
        % the Hessian is the sum of the Hessians of each equation weigthed by the
        % corresponding lagrange multiplier
        % i.e. H=sum(H(i)*lambda(i)))
        %first index of lagrangean = 2(objectives)+rules+forward
        %% Time t:
        
        % pause
        
        
        filag=size(fwmod,1);% as will start counting from first lagr after forward
        % [Hbt]=get_hessy2(lagnam,bwmod,filag,vary,vary);
        name='Hbt';
        lq_get_hessy3(name,namemod,lagnam,bwmod,filag,vary,vary,ext_ss,smb);
        
        
        
        %% Time t-1
        %% only bwconstraint
        
        
        filag=size(fwmod,1);
        % [Hbt_m1]=get_hessy2(
        name='Hbt_m1';
        lq_get_hessy3(name,namemod,lagnam,bwmod,filag,tmp_b,tmp_b,ext_ss,smb);
        %% Time t+1
        %% only fwconstraint
        
        
        
        %% cross derivatives
        %% current-back: bwconstr
        filag=size(fwmod,1);
        % [Hbt_cm1]=get_hessy2(
        name='Hbt_cm1';
        lq_get_hessy3(name,namemod,lagnam,bwmod,filag,vary,tmp_b,ext_ss,smb);
        
        %% back-shocks: bwconst
        filag=size(fwmod,1);
        % [Hbt_m1s]=get_hessy2(
        name='Hbt_m1s';
        lq_get_hessy3(name,namemod,lagnam,bwmod,filag,tmp_b,ex_var,ext_ss,smb);
        %% current-shocks: bwconst
        filag=size(fwmod,1);
        % [Hbt_cs]=get_hessy2(
        name='Hbt_cs';
        lq_get_hessy3(name,namemod,lagnam,bwmod,filag,vary,ex_var,ext_ss,smb);
        %%%%%%%%%%%%%%%%%
        
        filag=0; %as will start from first lagrangean
        % [Hft_p1]=get_hessy2(
        name='Hft_p1';
        lq_get_hessy3(name,namemod,lagnam,fwmod,filag,tmp_f,tmp_f,ext_ss,smb);
        
        %% current-shocks: fwconst
        filag=0;
        % [Hft_cs]=get_hessy2(
        name='Hft_cs';
        lq_get_hessy3(name,namemod,lagnam,fwmod,filag,vary,ex_var,ext_ss,smb);
        %% fwd-shocks: fwconst
        filag=0;
        % [Hft_p1s]=get_hessy2(
        name='Hft_p1s';
        lq_get_hessy3(name,namemod,lagnam,fwmod,filag,tmp_f,ex_var,ext_ss,smb);
        
        % forward
        filag=0; % 0 means that must not jump to costate variable index filag+1; fwd equations enter first!
        % [Hft]=get_hessy2(lagnam,fwmod,filag,vary,vary);
        name='Hft';
        
        lq_get_hessy3(name,namemod,lagnam,fwmod,filag,vary,vary,ext_ss,smb);
        
        %% forward-current: fwconstr
        filag=0;
        % [Hft_p1c]=get_hessy2(
        name='Hft_p1c';
        lq_get_hessy3(name,namemod,lagnam,fwmod,filag,tmp_f,vary,ext_ss,smb);
        
        %% current-shocks: objective
        filag=[];
        % [Hut_cs]=get_hessy2(
        
        name='Hut_cs';
        lq_get_hessy3(name,namemod,lagnam,umod,filag,vary,ex_var,ext_ss,smb);
        
        filag=[]; % when empty prompt the differentiatio of the rhs of utility expression
        % [Hut]=get_hessy2(lagnam,umod,filag,vary,vary);
        name='Hut';
        lq_get_hessy3(name,namemod,lagnam,umod,filag,vary,vary,ext_ss,smb);
        
        % % Save results in files
        % %1);
        % name='Hft';
        % save_hessy(name);
        % %%
        % name='Hbt';
        % save_hessy(name);
        % %%
        % name='Hut';
        % save_hessy(name);
        % %%
        % name='Hbt_m1';
        % save_hessy(name);
        % %%
        % name='Hft_p1';
        % save_hessy(name);
        % %%
        % name='Hbt_cm1';
        % save_hessy(name);
        % %%
        % name='Hft_p1c';
        % save_hessy(name);
        % %%
        % name='Hbt_m1s';
        % save_hessy(name);
        % %%
        % name='Hbt_cs';
        % save_hessy(name);
        % %%
        % name='Hft_cs';
        % save_hessy(name);
        % %%
        % name='Hut_cs';
        % save_hessy(name);
    end %if lq
end

return