%% Regenerate Hessian from Vech of socs
% This can be used to evaluate SOCs at any point
% Here the example shows how to evaluate SOCs at the 
% deterministic steady state.
% (1)  RUN Dynare on the model containing SOCs
% (2) Find position of SOCs in vector of endogenous variables
[xx,pos_soc]=find_incell(M_.endo_names,'\<soc_');
% (3) Evaluate each SOC: either looping through or otherwise
%        nmsoc=M_.endo_names(pos_soc,:);
%        vc_soc=zeros(size(nmsoc,1),1);
%        for jj=1:size(nmsoc,1);
%        vc_soc(jj,1)=eval(nmsoc(jj));
%        end
% (4) This case shows how to evaluate at the steady state
stst=eval([M_.fname,'_steadystate']);
vc_soc=stst(pos_soc);
% (5) Calculate original size of problem (since have vech of SOCs)
szM=(-1+sqrt(1+8*length(vc_soc)))/2;
% (6) Use this function to generate the orignial Hessian
[vv,Dn]=vech3(szM);
HH=reshape(Dn*vc_soc,szM,szM);
% (7) Calculate the eigenvalues
eigH=eig(HH);
% (8) For a minimum want the largest eigenvalue to be non-positive
max_eigH=max(eigH);
% (9) Print max eigenval
fprintf('Maximum eigenvalue (for a minimum must be <=0): %2.5f\n',max_eigH)