% Compute the covariance between lagged lagrangeans and endogenous
% variables
%[penalty,penalty_pp]=covariance_lagrangean(Ao,Bo,namelagr,nameutil,M_o,varcov_o,Jmx,Ao,Bo,As,Bs,M_s,ststs)
% Output: penalty term, penalty term per period (i.e. *(1-beta)), fromo
% 1/(1-beta)*(steady-state utility)=V_0+phi(-1)*y/beta;
% inputs: such that
% System is Zo=Ao*Zo(-1)+Bo*epsilon and Zs=As*Zs(-1)+Bs*epsilon
% The covariance between Zo and Zs is E_t(Zo*Zs'). Note that we want the
% conditional covariance, conditional on t-1 being under the optimal policy
% Define Zo_s=Zo(excluding lagrangeans)
% i.e. E(Zo*Zs')=Ao*E(Zo(-1)*Zo_s(-1)')*As'+Bo*Sigma^2*Bs';
% Then we can take the unconditional expectation of this and solve for the
% covariance term: Define it as ZZ, then ZZ(position lagr.,posit. endog) is
% the covariance of interest.
% NOTE though that we are looking for the correlation between lagged
% Lagrange multipliers and endogenous variables. Thus we only have to
% advance the endogenous variables
% i.e. E(Zo*Zs')=E(Zo(-1)*Zo_s(-1)')*As';where +Zo(-1)*epsilon'*Bs' drops
% out as epsilon is iid.
% OUTPUT: penalty where
% penalty=1/betta*vec(ZZ(pos_lagr(1:size(Jmx,1)),pos_endo))'*vec(Jmx); as
% in Benigno-Woodford LQ solution JET 2012
%@giovanni.lombardo@bis.org; 2017;
function [penalty, penalty_pp]=covariance_lagrangean(namelagr,nameutil,M_o,varyo,varcov_o,mean_o,ststo,Jmx,Ao,Bo,As,Bs,M_s,ststs)
penalty=[];
ZZ=[];
%% find position of Lagrange multipliers
[xx,pos_lagr]=find_incell(M_o.endo_names,namelagr); %here order of endogenous is irrelevant. That of multipliers is correct

M_s.endo_names=str2cell(M_s.endo_names);
M_o.endo_names=str2cell(M_o.endo_names);

%% Make sure common variables are in the same order
[io,neword_so]=ismember(M_o.endo_names,M_s.endo_names);
neword_so=neword_so(io);
oth=setdiff([1:M_s.endo_nbr]',neword_so);
neword_so=[neword_so;oth];
M_s.endo_names=M_s.endo_names(neword_so,:);
As=As(neword_so,neword_so);
Bs=Bs(neword_so,:);
ststs=ststs(neword_so);

%% Need to reorder variables and coefficient matrices as Jft is in alphabetical order (LCaps first)
varyo{end+1}=nameutil;
[nouse,neword_vary]=sort(upper(varyo));
varyo=varyo(neword_vary,:);
tmp_o=M_o.endo_names(1:pos_lagr(1)-1,:);
[nouse,neword_o]=ismember(upper(varyo),upper(tmp_o));% Need to reorder variables as Jft is in alphabetical order (case insensitively)
% jj_o=tmp_o(neword_o,:);
tmp_s=M_s.endo_names(1:pos_lagr(1)-1,:);
[nouse,neword_s]=ismember(upper(varyo),upper(tmp_s));% Need to reorder variables as Jft is in alphabetical order (case insensitively)
neword_s=neword_s(neword_s>0);
% jj_s=tmp_s(neword_s,:);
M_s.endo_names(1:length(neword_s),:)=tmp_s(neword_s,:);
M_o.endo_names(1:length(neword_o),:)=tmp_o(neword_o,:);

%% reorder endogenous variables (shocks should always be last)
So=eye(size(Ao));
So(1:length(neword_o),1:length(neword_o))=So(neword_o,1:length(neword_o));
Ss=eye(size(As));
Ss(1:length(neword_s),1:length(neword_s))=Ss(neword_s,1:length(neword_s));
Ao2=So*Ao*So';
Bo2=So*Bo;
As2=Ss*As*Ss';
Bs2=Ss*Bs;

%%



% varcov_o(1:pos_lagr(1)-1,1:pos_lagr(1)-1)=varcov_o(neword_o,neword_o);
% varcov_o(pos_lagr,1:pos_lagr(1)-1)=varcov_o(pos_lagr,neword_o);
% varcov_o(1:pos_lagr(1)-1,pos_lagr)=varcov_o(neword_o,pos_lagr);
if ~isempty(mean_o)
    mean_o(1:pos_lagr(1)-1,:)=mean_o(neword_o,:);
end
% As(1:pos_lagr(1)-1,1:pos_lagr(1)-1)=As(neword_s,neword_s);
% try
%     As(pos_lagr,1:pos_lagr(1)-1)=As(pos_lagr,neword_s);
% catch
% end

ststs(1:pos_lagr(1)-1)=ststs(neword_s);

ststo(1:pos_lagr(1)-1)=ststo(neword_o);

%% find positions of endogenaous variables
pos_util=find_incell(M_o.endo_names,nameutil);
pos_util_s=find_incell(M_s.endo_names,nameutil);
pos_shocks=[pos_lagr(end)+1:pos_lagr(end)+M_s.exo_nbr]';
pos_endo=setdiff(1:size(M_o.endo_names,1),[pos_util;pos_lagr;pos_shocks]);
%%
ZZ0=zeros(size(Ao2));
horiz=2000;
for jj=1:horiz
    ZZ0=Ao2*ZZ0*Ao2'+Bo2*M_s.Sigma_e*Bo2';
end

%% Alternative is too memory demanding
% tmp=(eye(numel(Ao2))-kron_d(Ao2,Ao2))\vec(Bo2*M_s.Sigma_e*Bo2');
% ZZ0=reshape(tmp,size(Ao2,1),size(Ao2,2));

% ck=find_incell(M_s.endo_names,namelagr);
% if ~isempty(ck)
%     AA=As2;
% else

% Select endogenous variables to be moved forward
err=[];
try
    if all(io)
        ZZ=ZZ0*As2';
    else
        error('endOfstory');
    end
catch err
end
if ~isempty(err)
SAo=eye(size(Ao2));
SAo=SAo(:,[1:length(neword_o),pos_shocks']);
SAs=eye(size(As2));
pos_shocks_s=size(As2,1)-M_s.exo_nbr+1:size(As2,1);

SAs=SAs([1:length(neword_s),pos_shocks_s],:);


ZZ=ZZ0*SAo*SAs*As2';
end

% Sigma_e=M_s.Sigma_e;
%% FROM
%         L=Ao*L(-1)+Bo*eps;
%         Sp1_L=As*Ss*So*Ao*L(-1)+As*Ss*So*Bo*eps+Bs*eps(+1);
%
%         E[L*Sp1_L']=E[Ao*L(-1)L(-1)'*Ao'*So'*Ss'*As'+Bo*eps*eps'*Bo'*So'*Ss'*As'];
%         E[L*Sp1_L']=ZZ={[Ao*varcov_o(-1)*Ao']+[Bo*Sigma*Bo']}*So'*Ss'*As';
%                  =varcov_o*So'*Ss'*As';
%
%
% ZZ=varcov_o(:,pos_endo)*As(:,pos_endo)'; % here we are assuming that pos_endo_o=pos_endo_s=pos_endo.
pos_betta=find_incell(M_s.param_names,'nbeta');
betta=M_s.params(pos_betta);
% Note that lagrangean are ordered so that the backward looking are fist
% hence ZZ(pos_lagr(1:size(Jmx,1)), where Jmx is the matrix on forward
% looking equations

penalty=1/betta*vec(ZZ(pos_lagr(1:size(Jmx,1)),pos_endo))'*vec(Jmx);
penalty_pp=penalty*(1-betta); %NOTE THAT THERE IS A PENALTY ONLY IN PERIOD 1
%penalty is to be added to the welfare value. First add the own to the
%optimal (i.e. where s=o) then add the penalty calculated on the suboptimal
%% steady state adjustment
ststdiff=(ststo(pos_endo)-ststs(pos_endo));
% if ~isempty(mean_o)&& any(abs(ststdiff))>1e-8
    tmp2=ststdiff'*As(pos_endo,pos_endo)'+ststs(pos_endo)';% Gianni 2 December 2017 it was ststdiff only; yet need level if ss differs
    tmp2=(mean_o(pos_lagr)+ststo(pos_lagr))*tmp2;
    supplem=1/betta*vec(tmp2(1:size(Jmx,1),:))'*vec(Jmx);
    penalty=penalty+supplem;
% elseif isempty(mean_o)&& any(abs(ststdiff))>1e-8
%     warning('Steady states are different: must provide second order mean of optimal policy model')
% end
penalty_pp=penalty*(1-betta);
return



