% % This script evaluate the LQ welfare equation produced by the code lq_symbol_welf
% % and stored in the file Welf4simul.m of the working directory
% % Welfare is evaluated by simulating data to first order and computing
% second moments of the data. In this way can evaluate rules based on
% non-linear algorithms e.g. under learning
%% HOW TO:
% -- Run the optimal policy in dynare (generate optimal policy with OPDSGE);
% -- Run lq_eval_welfare and save the results as reference (just follow
%    instructions)
% -- Run lq_symbol_welf and follow instructions
% -- Generate a simulated series for the alternative policy (e.g.
%    under learning).
% -- Run this code


if 1 % example of generating series out of Dynare output
    %% Generate VAR representation to produce expectations: Alternatively provide expectations in <name_var>_p1 variables
    [A]=dynare_VAR_representation;
    if isempty(oo_.endo_simul)
        error('Must generate simulations');
    end
    siml=oo_.endo_simul';
    
    drop=floor(size(siml,1)*.1);
    siml=siml(drop+1:end,:);
    siml=demean(siml);
    siml_p1=siml*A';
    % Associate variable names to simulations (in columns)
    
    vary_names=str2cell(M_.endo_names);
    for jj=1:length(vary_names)        
        eval([regexprep([vary_names{jj},'_p1'],'\s*',''),'=siml_p1(2:end,',num2str(jj),');']);
        eval([regexprep([vary_names{jj},'_m1'],'\s*',''),'=siml(1:end-1,',num2str(jj),');']);
        eval([regexprep(vary_names{jj},'\s*',''),'=siml(2:end,',num2str(jj),');']);
    end
end
if exist('Welf4simul.m','file')==0
    disp('Must generate the file Welf4simul.m following instructions on top of this file')
end

run('Welf4simul.m')

cprintf('string',sprintf('Welfare under current policy = %2.8f \n',LQ_welfare/(size(siml,1)-1)))
    