% This is the first code of a set that constructs the matrices (Hessians) 
% necessary to implement the LQ solution of Benigno and Woodford (NBER
% November, 2006, equation 2.19)
% This code retrieves the model and returns the indeces of the will be
% Lagrange's multipliers of forward-looking equations and backward-looking
% equations
% Syntax: lq_1_get_mod name_of_mod_file Util Welf policy_id extention
% where Util is the name of the objective function variable
%       Welf is the Welfare definitio (as used in get_ramsey)
%       policy_id is the name of the parameter used to identify the policy
%       equations (i.e. in the policy rule you must enter a parameter e.g.
%       poly that is unique to the policy rules: example
%       R=rho*R(-1)+lambda*pi(+1)+poly; This parameter will have value zero
%       in the parameter values;
%       Extension= string to append to filename of new mod file (and
%       associated LQ matrices (default = _lq);
% Also it rebuilds the mod file following the convention in Benigno
% Woodford LQ approach that fwd-looking equations don't have lagged
% variables.
% It constructs the FOC for the ramsey problem in order to get the stst
% lagrange multipliers 
% It also computes the second order derivatives to obtain the BW eq. 2.19
% LQ welfare.
% Giovanni Lombardo, ECB, January 2007
function varargout=lq_1_get_mod(varargin)

%preamble on generating a copy of the mod file in BW notation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if isempty(varargin)
    disp('You can write directly >> lq_1_get_mod namefile name_utility name_welfare')
    disp('____________________________________________________')
fname=input('Give name of .mod file ','s');
utilstr=input('Give name of objective function ','s');
welfstr=input('Give name of welfare function ','s');
pol_id=input('Give parameter that identifies policy equation (this must appear only in the policy equation):  ','s');
namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');

elseif nargin==1
        fname=varargin{1};
utilstr=input('Give name of objective function ','s');

welfstr=input('Give name of welfare function ','s');
pol_id=input('Give parameter that identifies policy equation (this must appear only in the policy equation):  ','s');
namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
lq_string=input('Give extention of namefile (default=_lq)','s');
if isempty(lq_string);
    lq_string='_lq';
end
elseif nargin==2
        fname=varargin{1};
    utilstr=varargin{2};
welfstr=input('Give name of welfare function ','s');
pol_id=input('Give parameter that identifies policy equation (this must appear only in the policy equation):  ','s');
namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
lq_string=input('Give extention of namefile (default=_lq)','s');
if isempty(lq_string);
    lq_string='_lq';
end

elseif nargin==3
        fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=input('Give parameter that identifies policy equation (this must appear only in the policy equation):  ','s');
namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
lq_string=input('Give extention of namefile (default=_lq)','s');
if isempty(lq_string);
    lq_string='_lq';
end


elseif nargin==4
    namelagr=input('Give Name Of Lagrange Multipliers of This Policy Maker: >> ','s');
    lq_string=input('Give extention of namefile (default=_lq)','s');
if isempty(lq_string);
    lq_string='_lq';
end
elseif nargin==5
    lq_string=input('Give extention of namefile (default=_lq)','s');
if isempty(lq_string);
    lq_string='_lq';
end
else
        fname=varargin{1};
    utilstr=varargin{2};
    welfstr=varargin{3};
    pol_id=varargin{4};
    namelagr=varargin{5};
    lq_string=varargin{6};
end



namemodN=regexp(fname,'\.');
if isempty(namemodN)
    namemodN=length(fname)+1;
    fname=strcat(fname,'.mod');
end
   if ~exist(fname,'file');
    disp(['The file <', fname ,'> could not be found in the current directory']);
    return
end 
namemod=fname(1:namemodN-1);


% modfile=(textread(fname,'%s','bufsize',1000000,'delimiter',';','commentstyle','c++'));
 modfile=(textread(fname,'%s','bufsize',1000000,'whitespace','\n'));%,




% modfile=modfile;

% search for string 'model' that appears as first non-commented string;


[modstrt,tmpst]= find_incell(modfile,'^model|(?<!(\S\s*))(model)');

% variables


[xx,vars]= find_incell(modfile(1:modstrt,:),'^var\>|(?<!(\S\s*))(var\>)');

[xx,endvars]= find_incell(modfile(1:modstrt,:),';');
endvars=endvars(endvars>=vars(1));
endings=[];
for jj=1:size(vars,1)
endings(jj,1)=min(endvars(endvars>=vars(jj)));
end

vary=[];
for jj=1:size(vars,1);
    vary{jj,1}=char(regexprep((strread(char(modfile(vars(jj):endings(jj),:))','%s','delimiter',';')),'\<var\>',''));
vary{jj,1}=eval([,'{''',regexprep(vary{jj,1},',',''','''),'''}']);
end
tmpv=[];
for jj=1:size(vary,1);
    tmp=(vary{jj}(:,:));
    for kk=1:max(size(tmp))
tmpv{end+1,1}=regexprep(tmp{kk},'\s+','');
    end
end
vary=tmpv;
if size(tmpst,1)>1
    disp('the word ''model'' appears more than once and in a conflicting way in lines')
    disp(tmpst')
    disp('Reserve the word ''model'' for the declarationo of the model and run <mod_red> again');
    return
end
% modstrt=tmpst;
% [xx,modjunk]=find_incell(modfile,'\<end');%strmatch('end',modfile);
% modend=min(modjunk(modjunk>modstrt));
[modend,tmpst]= find_incell(modfile,'^end|(?<!(\S\s*))(end)');
model=modfile(modstrt+1:modend-1,:);

[shocks_strt,shocks]= find_incell(model,'(?<=(\s*\/\/\s*\w*\s+))(shocks)','ignorecase');
if isempty(shocks_strt)
    disp('Must indicate the beginning of the block of exogenous shocks');
    return
end
shock_block=model(shocks_strt:end,:);
model=model([1:shocks_strt],:);
% find exogenous variables
ex_var=[];
zz=1;
[xx,commented_line]=find_incell(shock_block,'(?<!(.\s*))(\/\/)');
idx=setdiff([1:size(shock_block,1)]',commented_line);
tmp_shock_block=shock_block(idx,:);

for jj=1:size(vary,1);
    
    tmp=((find_incell(tmp_shock_block,['(?<!\w)',vary{jj},'[\s*\+\-\(\)\/\*\^\=;]'])));
    if ~isempty(tmp)
        ex_var{zz,1}=(vary{jj});
        zz=zz+1;
    end
end
if isempty(ex_var);
    disp('Could not identify the equations block of the shocks');
    return
end
vary=setdiff(vary,ex_var);
% % order variables alphabetically
% [a,srt_end]=sortrows(lower(vary));
% vary=vary(srt_end,:);
% [a,srt_ex]=sortrows(lower(ex_var));
% ex_var=ex_var(srt_ex,:);
%% get rid of commented blocks
% save in temp file
fid=fopen('temp.m','w');
fclose(fid);
fopen('temp.m','a+');
for jj=1:size(model,1);
    fprintf(fid,'%s\n',[model{jj}]);
end
fclose(fid);

% model=(textread('temp.m','%s','bufsize',1000000,'delimiter',';','commentstyle','c++','whitespace','\n'));
model=(textread('temp.m','%c','bufsize',1000000,'whitespace','\n','commentstyle','c++'));
model=(strread(model','%s','delimiter',';'));
delete temp.m

tmp1=['(?<!\W)(',deblank(utilstr),'\>)'];
[xx,util]=find_incell(model,tmp1);
obj_fnc=model(xx,:);

tmp2=['(?<!\W)(',deblank(welfstr),'\>)'];

[xx,welf]=find_incell(model,tmp2);

welf_fnc=model(xx,:);
 
tmp3=['(?<!\w)(',deblank(pol_id),'\)*\>)'];

[xx,policy]=find_incell(model,tmp3);
policy_eq=model(policy,:);

utilwelfpoly=[util;welf;policy];

nowelf=setdiff([1:size(model,1)]',utilwelfpoly);
model=model(nowelf,:);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% turn rest of model (i.e. constraints) into lhs expressions: in this way apply convention that
% rhs terms are subtracted from lhs terms: hence preserving sign of
% constraints in computing LQ solution
tmp_mod=[];
for jj=1:size(model,1);
    xx=regexp(model{jj},'\=');
    if ~isempty(xx)
     tmp_1=regexp(model{jj},'(?<=\=).*','match');
     tmp_2=regexp(model{jj},'.*(?=\=)','match');
     model{jj}=[char(tmp_2),'-(',char(tmp_1),')=0'];
    end
end
        
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[xx,fwd_eq]=find_incell(model,'(?<![\^ \+ \- \/ \* \()\(\+[1-9]*\)');

% check if there are lags in fwd_eq: if so generate dummy variables:

mod_fwd=model(fwd_eq,:);

new_block=[];
newvars=[];
new_ss_block=[];
z=1;
for jj=1:size(mod_fwd,1);
    [xx]=regexp(mod_fwd{jj},'([a-zA-Z1-9\_]*\(\-[1-9]*\))','match');

    if ~isempty(xx)
        for kk=1:size(xx',1)
             uu=regexp(char(xx{kk}),'([a-zA-Z1-9\_]*)(?=(\(\-[1-9]*\)))','match');
                    nuu=regexprep(char(xx{kk}),'[a-zA-Z1-9\_]*(?=\((\-[1-9]*\)))','');
                    nuu=regexprep(nuu,'[\(\)\-]','');
            tmp=['dummy_lq_',char(uu),'_',char(nuu)];
%             tmp=['dummy_lq_',num2str(kk),'_',num2str(jj)];
            newvars{z,1}=tmp;

            new_block{z,1}=[tmp,'-(',char(xx{kk}),')=0'];
            new_ss_block{z,1}=[tmp,'=',regexprep(char(xx{kk}),'(\-[1-9]*\)',''),';'];
            tmp2=regexprep(char(xx{kk}),'\(','\\(');
            tmp2=regexprep(tmp2,'\)','\\)');
            tmp2=regexprep(tmp2,'\-','\\-');
            tmp2=regexprep(tmp2,'\_','\\_');
            xx{kk}=tmp2;
            tmp=regexprep(tmp,'\_','\\_');

            mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)(',xx{kk},')'],tmp);
            z=z+1;
        end
    end
end

%%% eliminate leads of exogenous shocks


dd=[];
for jj=1:size(ex_var,1)-1;
    dd=[dd,'(',regexprep(deblank(ex_var{jj}),'\_','\\_'),')\(\+[1-9]*\)|'];
end
dd=[dd,'(',regexprep(deblank(ex_var{jj+1}),'\_','\\_'),')\(\+[1-9]*\)'];
for jj=1:size(mod_fwd,1);
[xx]=regexp(mod_fwd{jj},[dd,'\(\+[1-9]*\)'],'match');
    
    if ~isempty(xx)
        for kk=1:size(xx',1)
                    uu=regexp(char(xx{kk}),'([a-zA-Z1-9\_]*)(?=(\(\+[1-9]*\)))','match');
                    nuu=regexp(char(xx{kk}),'\(\+[1-9]*\)','match');
                    indx=regexprep(nuu,'\(','\\(');
                    indx=regexprep(indx,'\)','\\)');
                    indx=regexprep(indx,'\+','\\+');
                    nuu=regexprep(nuu,'[\(\)]','');
                    nuu=regexprep(nuu,'\+','pl');
            tmp=['dummy_lq_',char(uu),'_',char(nuu)];
            newvars{z,1}=tmp;

            new_block{z,1}=[tmp,'-(',regexprep(char(xx{kk}),'\(\+[1-9]*\)',''),')=0'];
            new_ss_block{z,1}=[tmp,'=',regexprep(char(xx{kk}),'(\+[1-9]*\)',''),';'];
            tmp2=regexprep(char(xx{kk}),'\(','\\(');
            tmp2=regexprep(tmp2,'\)','\\)');
            tmp2=regexprep(tmp2,'\-','\\-');
            tmp2=regexprep(tmp2,'\_','\\_');
            tmp2=regexprep(tmp2,'\+','\\+');
            xx{kk}=tmp2;
            tmp=[regexprep(tmp,'\_','\\_'),char(indx)];

           mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)(',xx{kk},')'],tmp);
            z=z+1;
          
        end
    end
end


%%%% eliminate leads-lags from objective and generate dummies instead

[xx]=regexp(obj_fnc{1},'[a-zA-Z1-9\_]*\(\-[1-9]*\)','match');
    
    if ~isempty(xx)
        for kk=1:size(xx',1)
                      uu=regexp(char(xx{kk}),'([a-zA-Z1-9\_]*)(?=(\(\-[1-9]*\)))','match');
                    nuu=regexprep(char(xx{kk}),'[a-zA-Z1-9\_]*(?=\((\-[1-9]*\)))','');
                    nuu=regexprep(nuu,'[\(\)\-]','');
            tmp=['dummy_lq_',char(uu),'_',char(nuu)];
            newvars{z,1}=tmp;

            new_block{z,1}=[tmp,'-(',char(xx{kk}),')=0'];
            new_ss_block{z,1}=[tmp,'=',regexprep(char(xx{kk}),'(\-[1-9]*\)',''),';'];
            tmp2=regexprep(char(xx{kk}),'\(','\\(');
            tmp2=regexprep(tmp2,'\)','\\)');
            tmp2=regexprep(tmp2,'\-','\\-');
            tmp2=regexprep(tmp2,'\_','\\_');
            xx{kk}=tmp2;
            tmp=regexprep(tmp,'\_','\\_');

           obj_fnc=regexprep(obj_fnc,['(?<!\w)(',xx{kk},')'],tmp);
            z=z+1;
        end
    end
%%% and leads
new_fwd_block=[];
w=1;
[xx]=regexp(obj_fnc{1},'[a-zA-Z1-9\_]*\(\+[1-9]*\)','match');
    
    if ~isempty(xx)
        for kk=1:size(xx',1)
                    uu=regexp(char(xx{kk}),'([a-zA-Z1-9\_]*)(?=(\(\+[1-9]*\)))','match');
                    nuu=regexprep(char(xx{kk}),'[a-zA-Z1-9\_]*(?=\((\+[1-9]*\)))','');
                    nuu=regexprep(nuu,'[\(\)]','');
                    nuu=regexprep(nuu,'\+','pl');
            tmp=['dummy_lq_',char(uu),'_',char(nuu)];
            newvars{z,1}=tmp;

            new_fwd_block{w,1}=[tmp,'-(',char(xx{kk}),')=0'];
            new_ss_block{z,1}=[tmp,'=',regexprep(char(xx{kk}),'(\+[1-9]*\)',''),';'];
            tmp2=regexprep(char(xx{kk}),'\(','\\(');
            tmp2=regexprep(tmp2,'\)','\\)');
            tmp2=regexprep(tmp2,'\-','\\-');
            tmp2=regexprep(tmp2,'\_','\\_');
            xx{kk}=tmp2;
            tmp=regexprep(tmp,'\_','\\_');

           obj_fnc=regexprep(obj_fnc{1},['(?<!\w)(',xx{kk},')'],tmp);
            z=z+1;
            w=w+1;
        end
    end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
new_ss_block=unique(new_ss_block);
new_block=unique(new_block);
new_fwd_block=unique(new_fwd_block);
  newvars=unique(newvars);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
bwd_eq=setdiff([1:size(model,1)]',fwd_eq);
mod_bwd=model(bwd_eq,:);
%szmb=size(mod_bwd,1);
for jj=1:size(new_block,1);
    mod_bwd{end+1}=new_block{jj};
end
%%
%szmf=size(mod_fwd,1);
for jj=1:size(new_fwd_block,1);
    mod_fwd{end+1}=new_fwd_block{jj};
end
% 

% save extended mod file

lq_name=[namemod,lq_string];
fid=fopen([lq_name,'.mod'],'w+');
disp(['New version of the mod file useful for the lq solution is in ',[namemod,'_lq.mod']]);
fprintf(fid,['// This is an extension of the file ',namemod,'.mod that;\n// eliminates from the forward looking ',...
    'equations backward looking variables;\n// it does this by generating dummy variables ;\n// version: ',datestr(now),';\n']);
fclose(fid);
fid=fopen([lq_name,'.mod'],'a+');
for jj=1:vars(1)-1;
    fprintf(fid,'%s\n',[modfile{jj},';']);

end
if ~isempty(newvars)
variables=regexprep(([cell2str(vary,0),',',cell2str(newvars,0)]),'[\[\]]','');
else
    variables=regexprep([cell2str(vary,0)],'[\[\]]','');
end
fprintf(fid,'%s','var  ');

    fprintf(fid,'%s\n',[variables,';']);
%exogenous variables

ex_variables=regexprep(([cell2str(ex_var,0)]),'[\[\]]','');

fprintf(fid,'%s\n','// Exogenous variables ');
fprintf(fid,'%s','var  ');

    fprintf(fid,'%s\n',[ex_variables,';']);
fprintf(fid,'%s\n','// ;');
for jj=endings(end)+1:modstrt;
    fprintf(fid,'%s\n',[modfile{jj}]);

end
fprintf(fid,'%s\n','// Welfare;');
fprintf(fid,'%s\n',[char(obj_fnc),';']);
fprintf(fid,'%s\n',[char(welf_fnc),';']);
policy_eq=strvcat(policy_eq);
for jj=1:size(policy_eq,1)
    fprintf(fid,'%s\n','// Policy Rule;');
    fprintf(fid,'%s\n',[policy_eq(jj,:),';']);
end
fprintf(fid,'%s\n','// ;');
for jj=1:size(mod_fwd,1);
    fprintf(fid,'%s\n',[mod_fwd{jj},';']);
end
fprintf(fid,'%s\n','// ;');
mod_bwd=strvcat(mod_bwd);
for jj=1:size(mod_bwd,1);
    fprintf(fid,'%s\n',[mod_bwd(jj,:),';']);
end
% fprintf(fid,'%s\n','// Dummy etries ;');
% for jj=1:size(new_block,1);
%     fprintf(fid,'%s\n',[new_block{jj}]);
% end
fprintf(fid,'%s\n','// ;');
for jj=1:size(shock_block,1);
    fprintf(fid,'%s\n',[shock_block{jj}]);
end
fprintf(fid,'%s\n','// ;');
for jj=1:size(modfile(modend:end,:),1);
    fprintf(fid,'%s\n',[modfile{modend+jj-1}]);
end
fclose(fid);
if exist ([namemod,'_steadystate.m'],'file')
    [yy xx]=dos(['copy ' namemod,'_steadystate.m ',[lq_name],'_steadystate.m']);
    if ~isempty(new_ss_block)
        tmp=(textread([[lq_name],'_steadystate.m'],'%s','bufsize',1000000,'whitespace','\n'));%
        
        tmp=regexprep(tmp,[namemod,'\_steadystate'],[regexprep([lq_name],'\_','\\_'),'\_steadystate']);
        
        [tt,init]=find_incell(tmp,['(?<!\w)lgy_[\s+\=]']);
        init=init(end);
        if isempty(init)
            disp('failed to add new steady-state block to ...steadystate file')
        else
            fid=fopen([[lq_name],'_steadystate.m'],'w+');
            fclose(fid);
            fid=fopen([[lq_name],'_steadystate.m'],'a+');
            for jj=1:init-1
                fprintf(fid,'%s\n',tmp{jj});
            end
            for jj=1:size(new_ss_block)
                fprintf(fid,'%s\n',new_ss_block{jj});
            end
            for jj=init:size(tmp,1)
                fprintf(fid,'%s\n',tmp{jj});
            end
            fclose(fid);
            disp('Generated copy of steadystate file with added new ss block')
        end

    end
end

%%%%%%%%%%%%%%%%%%%% output business(not very usefule now)
% model=dyn2mine(model,5);
% obj_fnc=dyn2mine(obj_fnc,5);
%  kk=struct('fwd_eq',fwd_eq,'bwd_eq',bwd_eq,'model',strvcat(model),'obj_fnc',obj_fnc,'new_ss_block',new_ss_block,...
%         'variables',vary);
%     
%     assignin('base','output_lq_1',kk);
    
    % all endogenous
    tmpvar=vary;
vary=regexprep(vary,['(\<',deblank(utilstr),'\>)|(\<',deblank(welfstr),'\>)'],'');
vary=strvcat(vary);
vary=str2cell(vary);
    uu=vary;
    
    for jj=1:size(newvars,1);
        uu{end+1,1}=newvars{jj};
    end
    namemod=[lq_name];
    
vary=uu;    


% order variables alphabetically
[a,srt_end]=sortrows(lower(vary));
vary=vary(srt_end,:);
[a,srt_ex]=sortrows(lower(ex_var));
ex_var=ex_var(srt_ex,:);

    eval(['save ',[namemod,'_variables.mat vary ex_var lq_string namelagr -MAT']]);

% if nargout>0
%    
%     varargout{1}=kk;
%     
%     
%    
% end
% assignin('base','bwd_eq',bwd_eq)
% assignin('base','fwd_eq',fwd_eq)
% 
% fprintf(['Output in the structure ''output_lq_1''\n'])
%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% GENERATE LAGRANGE MULTIPLIERS NAMES AND
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% VARIABLES AT DIFFERENT TIME 
lagnam=[];
for jj=1:size(mod_bwd,1)+size(mod_fwd,1);
    lagnam{jj,1}=[deblank(namelagr),num2str(jj)];
end

%%%%%%%%%%%%%%%%%%% transform numerical subscripts into strings
fwmod=dyn2mine(mod_fwd,5);
bwmod=dyn2mine(mod_bwd,5);
umod=dyn2mine(obj_fnc,5);




%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% stst lagrangean stuff
%%

tmp_f=[];
for jj=1:size(vary,1);
    tmp_f{jj,1}=[deblank(vary{jj}),'_plus1'];
    
end
tmp_b=[];
for jj=1:size(vary,1);
    tmp_b{jj,1}=[deblank(vary{jj}),'_minus1'];
    
end

filag=0; % non-empty for constraint
name='Jft';
lq_get_grady3(name,namemod,fwmod,filag,vary);

%%
filag=0; % non-empty for constraint
name='Jft_p1';
lq_get_grady3(name,namemod,fwmod,filag,tmp_f);

%%
filag=0; % non-empty for constraint
name='Jbt';
lq_get_grady3(name,namemod,bwmod,filag,vary);

%%
filag=0; % non-empty for constraint
name='Jbt_m1';
lq_get_grady3(name,namemod,bwmod,filag,tmp_b);

%%
filag=[]; % empty for objective
name='Jut';
lq_get_grady3(name,namemod,umod,filag,vary);

%%%%%%%%%%%%%%%%%%%%%%%%% HESSIAN STUFF
% ss_str='\_ss';
% the Hessian is the sum of the Hessians of each equation weigthed by the
% corresponding lagrange multiplier
% i.e. H=sum(H(i)*lambda(i)))
%first index of lagrangean = 2(objectives)+rules+forward
%% Time t:



filag=size(fwmod,1);
% [Hbt]=get_hessy2(lagnam,bwmod,filag,vary,vary);
name='Hbt';
lq_get_hessy3(name,namemod,lagnam,bwmod,filag,vary,vary);



%% Time t-1
%% only bwconstraint


filag=size(fwmod,1);
% [Hbt_m1]=get_hessy2(
name='Hbt_m1';
lq_get_hessy3(name,namemod,lagnam,bwmod,filag,tmp_b,tmp_b);
%% Time t+1
%% only fwconstraint



%% cross derivatives
%% current-back: bwconstr
filag=size(fwmod,1);
% [Hbt_cm1]=get_hessy2(
name='Hbt_cm1';
lq_get_hessy3(name,namemod,lagnam,bwmod,filag,vary,tmp_b);

%% back-shocks: bwconst
filag=size(fwmod,1);
% [Hbt_m1s]=get_hessy2(
name='Hbt_m1s';
lq_get_hessy3(name,namemod,lagnam,bwmod,filag,tmp_b,ex_var);
%% current-shocks: bwconst
filag=size(fwmod,1);
% [Hbt_cs]=get_hessy2(
name='Hbt_cs';
lq_get_hessy3(name,namemod,lagnam,bwmod,filag,vary,ex_var);
%%%%%%%%%%%%%%%%%

filag=0;
% [Hft_p1]=get_hessy2(
name='Hft_p1';
lq_get_hessy3(name,namemod,lagnam,fwmod,filag,tmp_f,tmp_f);

%% current-shocks: fwconst
filag=0;
% [Hft_cs]=get_hessy2(
name='Hft_cs';
lq_get_hessy3(name,namemod,lagnam,fwmod,filag,vary,ex_var);
%% fwd-shocks: fwconst
filag=0;
% [Hft_p1s]=get_hessy2(
name='Hft_p1s';
lq_get_hessy3(name,namemod,lagnam,fwmod,filag,tmp_f,ex_var);

% forward
filag=0; % 0 means that must not jump to costate variable index filag+1; fwd equations enter first!
% [Hft]=get_hessy2(lagnam,fwmod,filag,vary,vary);
name='Hft';

lq_get_hessy3(name,namemod,lagnam,fwmod,filag,vary,vary);

%% forward-current: fwconstr
filag=0;
% [Hft_p1c]=get_hessy2(
name='Hft_p1c';
lq_get_hessy3(name,namemod,lagnam,fwmod,filag,tmp_f,vary);

%% current-shocks: objective
filag=[];
% [Hut_cs]=get_hessy2(

name='Hut_cs';
lq_get_hessy3(name,namemod,lagnam,umod,filag,vary,ex_var);

filag=[]; % when empty prompt the differentiatio of the rhs of utility expression
% [Hut]=get_hessy2(lagnam,umod,filag,vary,vary);
name='Hut';
lq_get_hessy3(name,namemod,lagnam,umod,filag,vary,vary);

% % Save results in files
% %1);
% name='Hft';
% save_hessy(name);
% %%
% name='Hbt';
% save_hessy(name);
% %%
% name='Hut';
% save_hessy(name);
% %%
% name='Hbt_m1';
% save_hessy(name);
% %%
% name='Hft_p1';
% save_hessy(name);
% %%
% name='Hbt_cm1';
% save_hessy(name);
% %%
% name='Hft_p1c';
% save_hessy(name);
% %%
% name='Hbt_m1s';
% save_hessy(name);
% %%
% name='Hbt_cs';
% save_hessy(name);
% %%
% name='Hft_cs';
% save_hessy(name);
% %%
% name='Hut_cs';
% save_hessy(name);
return