% first order discounted sumvarcov
function [sum_varcov,varcov]=lq_fo_varcov(A,B,Sigma,hor,bet,dr_,pos_s);
% y=A*y(-1)+B*epsilon;
% y*y'=A*y(-1)*y(-1)'*A'+B*epsilon*epsilon'*B';epsilon=iid;
if nargin>5&isfield(dr_,'vc')
    
    varcov=dr_.vc(pos_s,pos_s);
else
    
    varcov=zeros(size(A));
end
sum_varcov=varcov*0;

% initializing at zero
if hor<inf | size(A,1)>50
    if hor>10000;hor=10000;end
    for jj=1:hor
        varcov=A*varcov*A'+B*Sigma*B';
        sum_varcov=sum_varcov+bet^(jj-1)*varcov;% no discount first entry (23.Apr.07)
    end
    % temp test with ergodic covariance
    sum_varcov=varcov;
else
    
    % asymptotic
    tmp0=kron_d_f(A,A);
    tmp01=kron_d_f(B,B);
    tmp1=(eye(size(tmp0))-bet*tmp0)\(tmp0*vec(varcov)+1/(1-bet)*tmp01*vec(Sigma));
    sum_varcov=reshape(tmp1,size(A));
    varcov=(eye(size(tmp0))-tmp0)\(tmp01*vec(Sigma));
    varcov=reshape(varcov,size(A));
end
% following commented out on 18.june.07: we are already starting from
% unconditional
% if nargin<=5&~isfield(dr_,'vc')
%     sum_varcov=sum_varcov+A*varcov*A'; % i.e. start from the unconditional variance;
% end
return