function [lgm_m1c,pos_s]=lq_fo_varcov_lagr(A,Sigma,hor,bet,dr_,lgy2_,extr_n);

% the economy has been under the optimal rule through t0-1, then have
% lambstar(-1)*y'=lambdstar(-1)*ystar(-1)*C;
% as y=C*y(-1)+D*epsilon

vary=str2cell(lgy2_);%(nstat+1:nstat+npred,:)
pos_s=[];
xx=[];
zz=1;
%  keyboard
for jj=1:size(vary,1);
    xx=(find_incell(str2cell(dr_.lgy2_),['\<',deblank(vary{jj}),'\>']));
    if ~isempty(xx)
        pos_s(zz,1)=(xx);
        zz=zz+1;
    end
end
% lq_transition_with_dummies; % modified 11.11.11 (not @ 11.11) -> the lagged dummies were missing
% alternative pursued is to introduce the dummies in the ad-hoc model too,
% so to have same number of endogenous, non-lagrangean variables
% A=Atemp;

% use the optimal varcov as the last period varcov;
% the order of the variables is extr_n must be the order in vary (order of
% differentiation)
% so pos_s maps the sequence of the optimal variance covariance (vc) -- consistent with dr_.lgy2_ --
%into the order of the new transition matrix A (sequence consistent with vary)
% extr_n, instead, makes sure that the order of the variables is the same
% of that of the gradient extracted during the lq parsing.
% keyboard
lgm_m1c=dr_.extr_lagr*dr_.vc(:,pos_s)*A'*extr_n'; 
% lgm_m1c=dr_.extr_lagr*dr_.vc(:,nolagr)*A(nolagr,nolagr)'*extr_n'; % the order of the variables is extr_n must be the order in vary (order of differentiation)

