function [lgm_m1c,pos_s]=lq_fo_varcov_lagr(A,C,Sigma,hor,bet,dr_,lgy2_,nstat,npred,extr_n);

% the economy has been under the optimal rule through t0-1, then have
% lambstar(-1)*y'=lambdstar(-1)*ystar(-1)*C;
% as y=C*y(-1)+D*epsilon

vary=str2cell(lgy2_(nstat+1:nstat+npred,:));
pos_s=[];
xx=[];
zz=1;

for jj=1:size(vary,1);
    xx=(find_incell(str2cell(dr_.lgy2_),['\<',deblank(vary{jj}),'\>']));
    if ~isempty(xx)
        pos_s(zz,1)=(xx);
        zz=zz+1;
    end
end
% use the optimal varcov as the last period varcov;
lgm_m1c=dr_.extr_lagr*dr_.vc(:,pos_s)*A'*C'*extr_n';

