% this code generates the FOC of the non-linear Lagrange probem
% L=sum(beta^i{U(y,y(-1))+lagrange'*[G(y(+1),y,eps);F(y,y(-1),eps)]})

function [foc]=lq_lagrange_problem(obj_func,mod_bwd,mod_fwd,vary,ex_var,lagr);

% assuming that functions are written in my notation and that there are no
% leads or lags >1 and that no leads and lags appear in the same equation
% (BW notation)

% first take FOC with respect to current variables
nvar=size(vary,1);
sfw=size(mod_fwd,1);
sbw=size(mod_bwd,1);
if size(obj_func,1)>1
    error('Objective is not a single equation');
end
xx=regexp(obj_func{1},'\=');

if ~isempty(xx)
    obj_func={obj_func{1}(1,xx+1:end)};
end
foc=cell(nvar,1);
for jj=1:nvar
%     if jj==4;keyboard;end
    foc{jj,1}=char(diff(sym(obj_func{1}),sym(vary{jj})));
    for kk=1:sfw
        tmp1=char(regexp(mod_fwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_fwd{kk}=tmp1;
        end
        try
        tmp=char(diff(sym(mod_fwd{kk}),sym(vary{jj})));
        catch
            keyboard
        end
        if ~isempty(regexp(tmp,'[^0]'));%tmp~=sym(0)
        foc{jj}=[foc{jj},'+',lagr{kk},'*(',tmp,')'];
        end
    end
    for kk=1:sbw
        tmp1=char(regexp(mod_bwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_bwd{kk}=tmp1;
        end
        tmp=char(diff(sym(mod_bwd{kk}),sym(vary{jj})));
        
        if ~isempty(regexp(tmp,'[^0]'));%tmp~=sym(0)
        foc{jj}=[foc{jj},'+',lagr{kk+sfw},'*(',tmp,')'];
        end
    end
end
    


% now change timing to the equations and redo the derivatives


rep=[];
vary_old=vary;
szvar=size(vary,1);
vary=str2cell(strvcat(strvcat(vary),strvcat(ex_var)));


vary=regexprep(vary,'\_','\\_');
for kk=1:size(vary)-1;
    rep=[rep,['(?<!\w)',deblank(vary{kk}),'(?!\w)|']];
end
rep=[rep,['(?<!\w)',deblank(vary{end}),'(?!\w)']];

% prepare forward block
for jj=1:size(mod_fwd,1)
   
    % current variables
    yy=regexp(mod_fwd{jj},rep,'match');
%     yy=yy{1}';
    for kk=1:size(yy',1)
        mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_minus1']);
    end    
     % lead variables
    xx=regexp(mod_fwd{jj},'\w+(\_plus1)','match');
%     xx=xx{1}';
    %xx=regexprep(xx,'\_plus1','');
    for kk=1:size(xx',1) 
    mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_plus1',''));
    end
end

% prepare backward block


for jj=1:size(mod_bwd,1)
   
    % current variables
    yy=regexp(mod_bwd{jj},rep,'match');
%     yy=yy{1}';
    for kk=1:size(yy',1)
        mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_plus1']);
    end    
     % lag variables
    xx=regexp(mod_bwd{jj},'\w+(\_minus1)','match');
%     xx=xx{1}';
    %xx=regexprep(xx,'\_plus1','');
    for kk=1:size(xx',1) 
    mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_minus1',''));
    end
end
% prepare objective

for jj=1:size(obj_func,1)
   
    % current variables
    yy=regexp(obj_func{jj},rep,'match');
%     yy=yy{1}';
    for kk=1:size(yy',1)
        obj_func{jj}=regexprep(obj_func{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_plus1']);
    end    
     % lag variables
     if isempty(mod_bwd);
         
         sprintf('NEED TO HAVE AT LEAST ONE LAGGED ENDOGENOUS VARIABLE\n (ADD ONE MULTIPLIED BY COEFF. SET TO ZERO)\n')
         
         error('')
     end
    xx=regexp(mod_bwd{jj},'\w+(\_minus1)','match');
%     xx=xx{1}';
    %xx=regexprep(xx,'\_plus1','');
    for kk=1:size(xx',1) 
    mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_minus1',''));
    end
end

% and redo the derivatives (with respect to vary_old (i.e. time t
% endogenous)
for jj=1:nvar
    foc{jj,1}=[foc{jj},'+nbeta*(',char(diff(sym(obj_func{1}),sym(vary_old{jj}))),')'];
    for kk=1:sfw
%         tmp1=char(regexp(mod_fwd{kk},'.+(?=\=)','match'));
%         if ~isempty(tmp1);
%             mod_fwd{kk}=tmp1;
%         end
        tmp=char(diff(sym(mod_fwd{kk}),sym(vary_old{jj})));
        if ~isempty(regexp(tmp,'[^0]'));%tmp~=sym(0)
        foc{jj}=[foc{jj},'+1/nbeta*',lagr{kk},'_minus1*(',tmp,')'];
        end
    end
    for kk=1:sbw
%         tmp1=char(regexp(mod_bwd{kk},'.+(?=\=)','match'));
%         if ~isempty(tmp1);
%             mod_bwd{kk}=tmp1;
%         end
        tmp=char(diff(sym(mod_bwd{kk}),sym(vary_old{jj})));
        if ~isempty(regexp(tmp,'[^0]'));%tmp~=sym(0)
        foc{jj}=[foc{jj},'+nbeta*',lagr{kk+sfw},'_plus1*(',tmp,')'];
        end
    end
end
return