% this code generates the SOC of the non-linear Lagrange probem
% L=sum(beta^i{U(y,y(-1))+lagrange'*[G(y(+1),y,eps);F(y,y(-1),eps)]})
% Input are the FOCs and outpu is the jacobian of the FOCs
function [soc,soc_T0]=lq_lagrange_problem_hessian(obj_func,mod_bwd,mod_fwd,vary,ex_var,lagr);

% assuming that functions are written in my notation and that there are no
% leads or lags >1 and that no leads and lags appear in the same equation
% (BW notation)

% first take FOC with respect to current variables
nvar=size(vary,1);
sfw=size(mod_fwd,1);
sbw=size(mod_bwd,1);
syms nbeta
if size(obj_func,1)>1
    error('Objective is not a single equation');
end
xx=regexp(obj_func{1},'\=');

if ~isempty(xx)
    obj_func={obj_func{1}(1,xx+1:end)};
end
soc=cell(nvar,1);

vars=cell2sym(vary);
lagry=cell2sym(lagr);
tot_vars=[vars;lagry];
%% FORWARD
soc1=vech2(hessian(sym(obj_func{1}),tot_vars)).';
    for kk=1:sfw
        tmp1=char(regexp(mod_fwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_fwd{kk}=tmp1;
        end
        soc2(kk,:)=vech2(hessian(lagry(kk)*sym(mod_fwd{kk}),tot_vars));
    end
    soc22=cell2str(sym2cell((sum(soc2,1)+soc1)));
    soc=soc22;
    
%% BACKWARD

    for kk=1:sbw
        tmp1=char(regexp(mod_bwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_bwd{kk}=tmp1;
        end
        soc3(kk,:)=vech2(hessian(lagry(kk+sfw)*sym(mod_bwd{kk}),tot_vars));
    end
  
    soc33=cell2str(sym2cell((sum(soc3,1)).'));
    soc=regexprep(str2cell([repmat('(',size(soc,1),1),soc,repmat(')',size(soc,1),1),repmat('+',size(soc,1),1),repmat('(',size(soc,1),1),soc33,repmat(')',size(soc,1),1)]),...
        '\s*','');
  soc=cell2str(soc);

%% now change timing to the equations and redo the derivatives


rep=[];
vary_old=vary; %still diff w.r.t. this
szvar=size(vary,1);
vary=str2cell(strvcat(strvcat(vary),strvcat(ex_var)));


vary=regexprep(vary,'\_','\\_');
for kk=1:size(vary)-1;
    rep=[rep,['(?<!\w)',deblank(vary{kk}),'(?!\w)|']];
end
rep=[rep,['(?<!\w)',deblank(vary{end}),'(?!\w)']];

%% prepare forward block
for jj=1:size(mod_fwd,1)
   
    % current variables
    yy=regexp(mod_fwd{jj},rep,'match');
%     yy=yy{1}';
    for kk=1:size(yy',1)
        mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_minus1']);
    end    
     % lead variables
    xx=regexp(mod_fwd{jj},'\w+(\_plus1)','match');
%     xx=xx{1}';
    %xx=regexprep(xx,'\_plus1','');
    for kk=1:size(xx',1) 
    mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_plus1',''));
    end
end

%% prepare backward block


for jj=1:size(mod_bwd,1)
   
    % current variables
    yy=regexp(mod_bwd{jj},rep,'match');
%     yy=yy{1}';
    for kk=1:size(yy',1)
        mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_plus1']);
    end    
     % lag variables
    xx=regexp(mod_bwd{jj},'\w+(\_minus1)','match');
%     xx=xx{1}';
    %xx=regexprep(xx,'\_plus1','');
    for kk=1:size(xx',1) 
    mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_minus1',''));
    end
end
%% prepare objective

for jj=1:size(obj_func,1)
   
    % current variables
    yy=regexp(obj_func{jj},rep,'match');

    for kk=1:size(yy',1)
        obj_func{jj}=regexprep(obj_func{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_plus1']);
    end    
     % lag variables
     if isempty(mod_bwd);
         
         sprintf('NEED TO HAVE AT LEAST ONE LAGGED ENDOGENOUS VARIABLE\n (ADD ONE MULTIPLIED BY COEFF. SET TO ZERO)\n')
         
         error('')
     end
    xx=regexp(mod_bwd{jj},'\w+(\_minus1)','match');

    for kk=1:size(xx',1) 
    mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_minus1',''));
    end
end

%% and redo the derivatives (with respect to vary_old (i.e. time t endogenous)
vars=cell2sym(vary_old);
lagry_m1=cell2sym(regexprep(str2cell([cell2str(lagr),repmat('_minus1',size(lagr,1),1)]),'\s*',''));
lagry_p1=cell2sym(regexprep(str2cell([cell2str(lagr),repmat('_plus1',size(lagr,1),1)]),'\s*',''));
%% 
%% FORWARD (DO YOU NEED TO ADD THIS TWICE UNDER TIMELESS PERSPECTIVE?)
soc1=nbeta*hessian(sym(obj_func{1}),tot_vars);
soc1=vech2(soc1).';
    for kk=1:sfw
        tmp1=char(regexp(mod_fwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_fwd{kk}=tmp1;
        end
        soc2(kk,:)=vech2(1/nbeta*hessian(lagry_m1(kk)*sym(mod_fwd{kk}),tot_vars));
    end
   
    soc22=cell2str(sym2cell((sum(soc2,1)+soc1).'));
      soc=regexprep(str2cell([soc,repmat('+',size(soc,1),1),repmat('(',size(soc,1),1),soc22,repmat(')',size(soc,1),1)]),...
        '\s*','');
    soc=cell2str(soc);
%% BACKWARD
    for kk=1:sbw
        tmp1=char(regexp(mod_bwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_bwd{kk}=tmp1;
        end
        soc3(kk,:)=vech2(nbeta*hessian(lagry_p1(kk+sfw)*sym(mod_bwd{kk}),tot_vars));
    end
   
    soc33=cell2str(sym2cell((sum(soc3,1)).'));
    soc=regexprep(str2cell([soc,repmat('+',size(soc,1),1),repmat('(',size(soc,1),1),soc33,repmat(')',size(soc,1),1)]),...
        '\s*','');
%% Generate SOC residuals

soc=[repmat('-soc_',size(soc,1),1),num2str([1:size(soc,1)]'),repmat('+',size(soc,1),1),cell2str(soc)];
soc=regexprep(str2cell(soc),'\s*','');

%% Time zero Socs
soc_T0=regexprep(sym2cell(soc2),'\s*','');

return