% this code generates the FOC of the non-linear Lagrange probem
% L=sum(beta^i{U(y,y(-1))+lagrange'*[G(y(+1),y,eps);F(y,y(-1),eps)]})

function [foc]=lq_lagrange_problem_jacobian(obj_func,mod_bwd,mod_fwd,vary,ex_var,lagr,namemod);

% assuming that functions are written in my notation and that there are no
% leads or lags >1 and that no leads and lags appear in the same equation
% (BW notation)

% first take FOC with respect to current variables
nvar=size(vary,1);
sfw=size(mod_fwd,1);
sbw=size(mod_bwd,1);
syms nbeta
if size(obj_func,1)>1
    error('Objective is not a single equation');
end
xx=regexp(obj_func{1},'\=');

if ~isempty(xx)
    obj_func={obj_func{1}(1,xx+1:end)};
end
foc=cell(nvar,1);

vars=cell2sym(vary);
lagry=cell2sym(lagr);
%% FORWARD
foc1=jacobian(sym(obj_func{1}),vars);
    for kk=1:sfw
        tmp1=char(regexp(mod_fwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_fwd{kk}=tmp1;
        end
        foc2(kk,:)=lagry(kk)*jacobian(sym(mod_fwd{kk}),vars);
    end
   
    foc22=cell2str(sym2cell((sum(foc2,1)+foc1).'));
    foc=foc22;
    
%% BACKWARD

    for kk=1:sbw
        tmp1=char(regexp(mod_bwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_bwd{kk}=tmp1;
        end
        foc3(kk,:)=lagry(kk+sfw)*jacobian(sym(mod_bwd{kk}),vars);
    end
   
    foc33=cell2str(sym2cell((sum(foc3,1)).'));
    foc=regexprep(str2cell([repmat('(',size(foc,1),1),foc,repmat(')',size(foc,1),1),repmat('+',size(foc,1),1),repmat('(',size(foc,1),1),foc33,repmat(')',size(foc,1),1)]),...
        '\s*','');
  foc=cell2str(foc);

%% now change timing to the equations and redo the derivatives


rep=[];
vary_old=vary;
szvar=size(vary,1);
vary=str2cell(strvcat(strvcat(vary),strvcat(ex_var)));


vary=regexprep(vary,'\_','\\_');
for kk=1:size(vary)-1;
    rep=[rep,['(?<!\w)',deblank(vary{kk}),'(?!\w)|']];
end
rep=[rep,['(?<!\w)',deblank(vary{end}),'(?!\w)']];

%% prepare forward block
for jj=1:size(mod_fwd,1)
   
    % current variables
    yy=regexp(mod_fwd{jj},rep,'match');
%     yy=yy{1}';
    for kk=1:size(yy',1)
        mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_minus1']);
    end    
     % lead variables
    xx=regexp(mod_fwd{jj},'\w+(\_plus1)','match');
%     xx=xx{1}';
    %xx=regexprep(xx,'\_plus1','');
    for kk=1:size(xx',1) 
    mod_fwd{jj}=regexprep(mod_fwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_plus1',''));
    end
end

%% prepare backward block


for jj=1:size(mod_bwd,1)
   
    % current variables
    yy=regexp(mod_bwd{jj},rep,'match');
%     yy=yy{1}';
    for kk=1:size(yy',1)
        mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_plus1']);
    end    
     % lag variables
    xx=regexp(mod_bwd{jj},'\w+(\_minus1)','match');
%     xx=xx{1}';
    %xx=regexprep(xx,'\_plus1','');
    for kk=1:size(xx',1) 
    mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_minus1',''));
    end
end
%% prepare objective

for jj=1:size(obj_func,1)
   
    % current variables
    yy=regexp(obj_func{jj},rep,'match');

    for kk=1:size(yy',1)
        obj_func{jj}=regexprep(obj_func{jj},['(?<!\w)',deblank(yy{kk}),'(?!\w)'],...
        [deblank(yy{kk}),'\_plus1']);
    end    
     % lag variables
     if isempty(mod_bwd);
         
         sprintf('NEED TO HAVE AT LEAST ONE LAGGED ENDOGENOUS VARIABLE\n (ADD ONE MULTIPLIED BY COEFF. SET TO ZERO)\n')
         
         error('')
     end
    xx=regexp(mod_bwd{jj},'\w+(\_minus1)','match');

    for kk=1:size(xx',1) 
    mod_bwd{jj}=regexprep(mod_bwd{jj},['(?<!\w)',xx{kk}],regexprep(xx{kk},'\_minus1',''));
    end
end

%% and redo the derivatives (with respect to vary_old (i.e. time t endogenous)
vars=cell2sym(vary_old);
lagry_m1=cell2sym(regexprep(str2cell([cell2str(lagr),repmat('_minus1',size(lagr,1),1)]),'\s*',''));
lagry_p1=cell2sym(regexprep(str2cell([cell2str(lagr),repmat('_plus1',size(lagr,1),1)]),'\s*',''));

%% FORWARD
foc1=nbeta*jacobian(sym(obj_func{1}),vars);
    for kk=1:sfw
        tmp1=char(regexp(mod_fwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_fwd{kk}=tmp1;
        end
        foc2(kk,:)=1/nbeta*lagry_m1(kk)*jacobian(sym(mod_fwd{kk}),vars);
    end
   %% save forward block for steady-state timeless penalty
   fid=fopen([namemod,'_forward_block.m'],'w+');
   mod_fwd_=regexprep(mod_fwd,'\_plus1|\_minus1','');
   fprintf(fid,'%s\n','Forward_Block=[');
   for cntfw=1:size(mod_fwd_,1)
       fprintf(fid,'%s\n',[mod_fwd_{cntfw},';']);
   end
   fprintf(fid,'%s\n','];');
   fclose(fid);
    foc22=cell2str(sym2cell((sum(foc2,1)+foc1).'));
      foc=regexprep(str2cell([foc,repmat('+',size(foc,1),1),repmat('(',size(foc,1),1),foc22,repmat(')',size(foc,1),1)]),...
        '\s*','');
    foc=cell2str(foc);
%% BACKWARD
    for kk=1:sbw
        tmp1=char(regexp(mod_bwd{kk},'.+(?=\=)','match'));
        if ~isempty(tmp1);
            mod_bwd{kk}=tmp1;
        end
        foc3(kk,:)=nbeta*lagry_p1(kk+sfw)*jacobian(sym(mod_bwd{kk}),vars);
    end
   
    foc33=cell2str(sym2cell((sum(foc3,1)).'));
    foc=regexprep(str2cell([foc,repmat('+',size(foc,1),1),repmat('(',size(foc,1),1),foc33,repmat(')',size(foc,1),1)]),...
        '\s*','');
% OLD

return