
function [lq_name]=lq_save_lq_mod(namemod,lq_string,tmpvar,modfile,vars,endings,newvars,...
    ex_var,lagnam,namelagr,modstrt,modend,obj_fnc,welf_fnc,policy_eq,mod_bwd,mod_fwd,...
    foc,soc,soc_ss,shock_block,new_ss_block,dervar);
if isunix
    cp='cp ';
else
    cp='copy ';
end
vary=tmpvar;
lq_name=[namemod,'_',lq_string];
fid=fopen([lq_name,'.mod'],'w+');
disp(['New version of the mod file useful for the lq solution is in ',[lq_name,'.mod']]);
fprintf(fid,['// This is an extension of the file ',namemod,'.mod that;\n// eliminates from the forward looking ',...
    'equations backward looking variables;\n// it does this by generating dummy variables ;\n// version: ',datestr(now),';\n']);
fclose(fid);
fid=fopen([lq_name,'.mod'],'a+');
for jj=1:vars(1)-1;
    fprintf(fid,'%s\n',[modfile{jj},';']);
    
end
if ~isempty(newvars)
    %     keyboard
    variables=regexprep(([cell2str(vary,0),',',cell2str(newvars,0)]),'[\[\]]','');
else
    variables=regexprep([cell2str(vary,0)],'[\[\]]','');
end
fprintf(fid,'%s','var  ');

fprintf(fid,'%s',[variables]);

% lagrange multipliers

% fprintf(fid,'%s\n','// Lagrange multipliers ');
if isempty(policy_eq)
    fprintf(fid,'%s\n',', ');
else
    fprintf(fid,'%s\n',', ');
    %      fprintf(fid,'%s','var  ');
    
    lagvar=regexprep([cell2str(lagnam,0)],'[\[\]]','');
    fprintf(fid,'%s\n',[lagvar,',']);
    
end
%% add second-order residual variables
if ~isempty(soc);
    vsoc=cell(size(soc,1),1);
    for jj=1:size(soc,1);
        vsoc{jj,1}=regexprep(['soc_',num2str(jj)],'\s*','');
    end
    fprintf(fid,'%s\n',[regexprep(cell2str(vsoc,0),'\[|\]',''),',']);
end

%exogenous variables

ex_variables=regexprep(([cell2str(ex_var,0)]),'[\[\]]','');

% fprintf(fid,'%s\n','// Exogenous variables ');
% fprintf(fid,'%s','var  ');

fprintf(fid,'%s\n',[ex_variables,';']);
fprintf(fid,'%s\n','// ;');

for jj=endings(end)+1:modstrt-1;
    fprintf(fid,'%s\n',[modfile{jj}]);
    
end
fprintf(fid,'%s','parameters nash_param aleph;  ');
fprintf(fid,'%s\n','// ;');
fprintf(fid,'%s\n',[modfile{modstrt}]);
fprintf(fid,'%s\n','// ;');
fprintf(fid,'%s\n','// Welfare;');
fprintf(fid,'%s\n',[char(obj_fnc),';']);
if ~isempty(welf_fnc);
    fprintf(fid,'%s\n',[char(welf_fnc),';']);
end
policy_eq=strvcat(policy_eq);
for jj=1:size(policy_eq,1)
    fprintf(fid,'%s\n','// Policy Rule;');
    fprintf(fid,'%s\n',['// ',policy_eq(jj,:),';']);
end
fprintf(fid,'%s\n','// ;');
for jj=1:size(mod_fwd,1);
    fprintf(fid,'%s\n',[mod_fwd{jj},';']);
end
fprintf(fid,'%s\n','// ;');
mod_bwd=strvcat(mod_bwd);
for jj=1:size(mod_bwd,1);
    fprintf(fid,'%s\n',[mod_bwd(jj,:),';']);
end
% fprintf(fid,'%s\n','// Dummy etries ;');
% for jj=1:size(new_block,1);
%     fprintf(fid,'%s\n',[new_block{jj}]);
% end
% fid=fopen([lq_name,'.mod'],'a+');

if ~isempty(policy_eq)
    fprintf(fid,'%s\n','// FOC of Lagrange problem ;');
    
    for jj=1:size(foc,1);
        fprintf(fid,'//%s FOC with respect to variable: %s\n',num2str(jj),[dervar{jj},';']);
        fprintf(fid,'%s\n',[foc{jj},'=0;']);
    end
    
end
if ~isempty(soc)
    
    fprintf(fid,'%s\n','// SOC of Lagrange problem ;');
    
    for jj=1:size(soc,1);
        fprintf(fid,'%s\n',[soc{jj},'=0;']);
    end
    
end
fprintf(fid,'%s\n','// Exogenous Shocks ;');
for jj=1:size(shock_block,1);
    fprintf(fid,'%s\n',[shock_block{jj}]);
end
fprintf(fid,'%s\n','// ;');
for jj=1:size(modfile(modend:end,:),1);
    fprintf(fid,'%s\n',[modfile{modend+jj-1}]);
end
fclose(fid);


%% %%%%%%%%%% steady state part





if exist ([namemod,'_steadystate.m'],'file')
    [yy xx]=system([cp , namemod,'_steadystate.m ',[lq_name],'_steadystate.m']);
    
    tmp=(textread([[lq_name],'_steadystate.m'],'%s','bufsize',1000000,'whitespace','\n'));%
    
    tmp=regexprep(tmp,[namemod,'\_steadystate'],[regexprep([lq_name],'\_','\\_'),'\_steadystate']);
    
    [tt,init]=find_incell(tmp,['evalin\(''base'',''lgy\_']);
    %                 [tt,init]=find_incell(tmp,['(?<!\w)',['''base'',''lgy\_'],'[\s+\=]']);
    %
    %         init=init(end);
    if isempty(init)
        disp('********************************************')
        fprintf('failed to add new steady-state block to ...steadystate file\n Need a block saying M_=evalin(''base'',''M_'')\n')
        disp('********************************************')
    else
        fid=fopen([[lq_name],'_steadystate.m'],'w+');
        fclose(fid);
        fid=fopen([[lq_name],'_steadystate.m'],'a+');
        for jj=1:init+1
            fprintf(fid,'%s\n',tmp{jj});
        end
        if ~isempty(new_ss_block)
            for jj=1:size(new_ss_block)
                fprintf(fid,'%s\n',new_ss_block{jj});
            end
        end
%         if ~isempty(soc)
%             vvsoc=regexprep(cell2str(vsoc,0),'\[','');
%             vvsoc=regexprep(vvsoc,'\]|\,','=0;');
%             fprintf(fid,'%s\n',vvsoc);
%             
%         end
        if ~isempty(foc)
            fprintf(fid,'%s\n',['namemod=evalin(''base'',''M_.fname'');']);
            fprintf(fid,'%s\n',['ext_pol_prob='''';']);
            fprintf(fid,'%s\n',['namelagr=''',namelagr,''';']);
            fprintf(fid,'%s\n',['load([namemod,''_info_4_lagr.mat'']);']);
            fprintf(fid,'%s\n',['lq_get_ss_lagr']);
            if ~isempty(soc)
                fprintf(fid,'%s\n',[lq_name,'_soc_steady_state;']);
            end
            
        end
        for jj=init:size(tmp,1)
            fprintf(fid,'%s\n',tmp{jj});
        end
        fclose(fid);
        disp('Generated copy of steadystate file ')
        
        if ~isempty(soc)
            fid=fopen([lq_name,'_soc_steady_state.m'],'w+');
            for cntsoc=1:size(soc_ss,1)
                tmpsoc=regexprep(soc_ss(cntsoc,:),deblank(['\-soc_',num2str(cntsoc),'\+']),deblank(['soc_',num2str(cntsoc),'=']));
                fprintf(fid,'%s\n',[tmpsoc{1},';']);
            end
            fclose(fid);
            disp(['Generated SOC steadystate file ',lq_name,'_soc_steady_state.m'])
        end
        
    end
end