% second order conditions

function [test]=lq_soc(Jft,Jft_p1,Jbt,Jbt_m1,Q,R,A_mx,pos_n,pos_lagr,bet);
% clear i pi
% D(L)=Jft_p1+Jft*exp(-theta*i);
% C(L)=Jbt+Jbt_m1*exp(-theta*i);
% accuracy=1e-10;
% Q=round(Q/accuracy)*accuracy;
% A1=round(2*R/accuracy)*accuracy;
% Jft=round(Jft/accuracy)*accuracy;
% Jft_p1=round(Jft_p1/accuracy)*accuracy;
% Jbt=round(Jbt/accuracy)*accuracy;
% Jbt_m1=round(Jbt_m1/accuracy)*accuracy;
% R=round(R/accuracy)*accuracy;
% A_mx=round(A_mx/accuracy)*accuracy;

accy=1e8;


A0=Q;
A1=2*R;

A=A0+A1;
n_fwd=size(Jft,1);
n_bwd=size(Jbt,1);
nash=0;
% pos_lagr_b=pos_lagr(n_fwd+1:end);
if length(pos_lagr)>n_fwd+n_bwd % e.g. non-cooperative equilibria
 nash=1  ;  
    pos_lagr=pos_lagr([1:n_fwd,n_fwd+n_bwd+1:2*n_fwd+n_bwd]);
    sz_l=2*n_fwd;%length(pos_lagr);% number of multipliers on forward looking constraints 

else    
pos_lagr=pos_lagr(1:n_fwd);
 sz_l=n_fwd;
end
ext_npllag=[pos_lagr;pos_n]; % as BW Paper not the Note
T=bet^(0.5)*A_mx(ext_npllag,ext_npllag);% check out the beta factor
% Ttilde=bet^(-0.5)*T, where T describes the motion of the rescaled variables

S=eye(size(T));
if nash
    S=S([n_fwd+1:n_fwd+n_bwd,2*n_fwd+n_bwd+1:end],:);
else
S=S(n_fwd+1:end,:);

end
sz_n=length(pos_n);
sz_min=(n_bwd+n_fwd);



% first test
 TMP=T'*(S'*(A0+A0')*S+bet^(0.5)*T'*S'*A1*S+bet^(0.5)*S'*A1'*S*T)*T;
%TMP=(S'*(A0+A0')*S+bet^(0.5)*T'*S'*A1*S+bet^(0.5)*S'*A1'*S*T);
%Jt=reshape((eye(size(T,1)^2)-kron_d_f(T',T'))\vec(TMP),size(T,1),size(T,2));
J=zeros(size(T'));
T=double(T);
TMP=double(TMP);
for jj=1:1000
    J=TMP+T'*J*T;
end
if 1 % eigenvalues
    disp('Using eigenvalue-test of matrix J');
    JJ=J(1:n_fwd,1:n_fwd);

    tmp_eig=eig(1/2*(JJ+JJ'));
    test(1,1)=-(max(round(accy*tmp_eig)/accy)<=0);
else
    disp('Using principal-minor-test of matrix J');
    %% principal minor
    ff=0;
    for kk=1:sz_l; % covering the number of forward looking constraints
        
        dtJ=round(accy*det(J(1:kk,1:kk)))/accy;
        ff(kk,1)=sign(dtJ)==sign((-1)^kk)|dtJ==0;
        if dtJ==0
            disp('semi-definiteness of J-matrix');
        end
    end
    %%

    test(1,1)=-min(ff);
end

M=zeros(size(Jbt,1)+size(Jft,1)+size(A,1),n_fwd+n_bwd+size(A,2));
%% second test
z=2;
imgp=0;
eigtstM=0;
imtmp=0;
if test(1,1)<0
     disp('J-matrix test ''passed''');
 else
            disp('J-matrix test failed');
end
    for theta=-pi:2*pi/100:pi
        A=A0+A1*bet^0.5*exp(-theta*i);
        At=A0'+A1'*bet^0.5*exp(theta*i);
       
        C=Jbt+Jbt_m1*bet^0.5*exp(-theta*i);
        Ct=Jbt'+Jbt_m1'*bet^0.5*exp(theta*i);
         D=bet^(-0.5)*exp(theta*i)*Jft_p1+Jft;% already transformed
         if rank([C;D])~=sz_min
         fprintf('rank condition not satisfied: deficiency %10i\n',rank([C;D])-sz_min)
         end
        Dt=bet^(-0.5)*exp(-theta*i)*Jft_p1'+Jft';% already transformed
        M(:,end-sz_n+1:end)=[C;
                            D;
                            1/2*(A+At)];
        M(end-sz_n+1:end,1:end-sz_n)=[Ct,Dt];
        if 0 % I'm not sure the eigenvalue-test is applicable here
            % what is tested is the negative-definiteness of the matrix M looking only
            % at sub-matrices or order p>2*(sz_min);
            % looking at the eig(M) have both <0 and >=0, so cannot tell.
            eigtstM=1;
           tmpM=1/2*(M+M');
            tmp_eigM=eig(tmpM);
           
            test(z,1)= -(min(round(accy*tmp_eig)/accy)<=0);
%             max(abs(imag(tmp_eigM)))
            if max(abs(imag(tmp_eigM)))>1/accy;
                    tmp=[max(abs(imag(tmp_eigM)))];
                 imgp=unique(max(imgp,tmp));    
                end
        else
            %% principal minors
            
            bb=[];
            
%             bbcount=1;
            for kk=2*sz_min+1:size(M,1);
                
%                 if abs(imag(det(M(1:kk,1:kk))))>1/accy;
%                     imtmp=max(imtmp,abs(imag(det(M(1:kk,1:kk))))/(abs(real(det(M(1:kk,1:kk))))+(1e-30)));
%                     tmp=[abs(imag(det(M(1:kk,1:kk))))];
%                  imgp=unique(max(imgp,tmp));    
%                 end
  

%                 real(det(M(1:kk,1:kk)))
%                 bb=[bb;sign(real(det(M(1:kk,1:kk))))==sign((-1)^(kk-sz_min))];
                bb=[bb;sign(prod(eig(M(1:kk,1:kk))))==sign((-1)^(kk-sz_min))];% in Debreu and in Telser and Graves it is simply kk and not kk-sz_min: but they have a typo (see Simon and Blume)
            end
            test(z,1)=-min(bb);
        end
        %%
        z=z+1;
    end
%  else
%             disp('J-matrix test failed: stopping here');
% end
if max(test)>=0;
    disp('Second order conditions not satisfied');
else
    if eigtstM==1;
         disp('Using eigenvalue-test of matrix M');
    end
    disp('M-matrix test passed')
    disp('======================================================')
    disp('Congratulations, Second Order Conditions satisfied :) ')
    if imgp>0
      fprintf('Large imaginary part in matrix M %10.5e\n',imgp);
      fprintf('Max imaginary/real part in matrix M %5.5e\n',imtmp);
    end
end
    return