% compute penalty term LQ evaluation
% 1) run optimal policy and save moments including varcovar and list of variables (rotated as in here below).
%      give name dr_opt.vc to variance covariance.
%      The name of the list of variables should be lgy2_
%        SEE FIRST BLOCK FOLLOWING THIS DIRECTIONS (around line 33) OR USE
%        VERBOSE VERSION (global verbose; verbose=1;)
% 2) run suboptimal policy and run this program (e.g. running variance_dynare)
% THE PENALTY TERMS MUST BE ADDED TO WELFARE
global verbose
if isempty(verbose) || verbose==1;
cases=menu('COMPUTING PENALTY TERM: STEPS','Save optimal (after you have run it)','Save suboptimal (after you have run it)');
else
    cases=2;
end
switch cases
    case 1 %RUN AFTER OPTIMAL ONLY
    variance_dynare;
    if options_.order==2
        cond_mom_dyn4;
        dr_opt.mean=oo_.mean;
    else
        dr_opt.mean=[];
    end
    dr_opt.vc=oo_.var;% i.e. variance-covariance in the order of lgy2_ computed in variance-dynare
    [Ao,Bo]=dynare_VAR_representation;
    tmp=load([M_.fname,'_variables.mat']);
    dr_opt.vary=tmp.vary;
    dr_opt.Ao=Ao;
    dr_opt.Bo=Bo;
    dr_opt.M_o=M_;
    dr_opt.lgy2_=M_.endo_names;
    dr_opt.fname_opt=M_.fname;
    dr_opt.stst=oo_.steady_state;
    save dr_opt.mat dr_opt  -MAT
    otherwise
variance_dynare;    
load dr_opt.mat    
Ao=dr_opt.Ao;
Bo=dr_opt.Bo;
M_o=dr_opt.M_o;
M_s=M_;
namelagr='ramsey';
nameutil='Util';
varcov_o=dr_opt.vc;
for jj=1:size(oo_.steady_state,1);
    eval([M_.endo_names(jj,:),'=',num2str(oo_.steady_state(jj)),';']);
end
eval(['Jft_p1_',dr_opt.fname_opt]) 
% The sign of the following is obviously crucial!! The derivative matrix is
% written with the SAME sign as the FOC (and thus Lagrange problem)
% are written. To see this check the Calvo example, and compare the FOC in
% the mod, the ss FOC in the Matrices... and the Jft_p1 matrix. 
Jmx=Jft_p1; 
[As,Bs]=dynare_VAR_representation;
[penalty,penalty_pp]=covariance_lagrangean(namelagr,nameutil,M_o,dr_opt.vary ,varcov_o,dr_opt.mean,dr_opt.stst,Jmx,Ao,Bo,As,Bs,M_s,oo_.steady_state);
if isempty(verbose) || verbose==1;
fprintf('Compensation for timeless perspective %5.5f \n',penalty)
fprintf('Compensation for timeless perspective %5.5f PER PERIOD \n',penalty_pp)
end
end
