% compute penalty term LQ evaluation
% 1) run optimal policy and save moments including varcovar and list of variables (rotated as in here below).
%      give name dr_opt.vc to variance covariance.
%      The name of the list of variables should be lgy2_
%        SEE FIRST BLOCK FOLLOWING THIS DIRECTIONS
% 2) run suboptimal policy and run this program (e.g. running variance_dynare)
% 

cases=menu('COMPUTING PENALTY TERM: STEPS','Save optimal (after you have run it)','Save suboptimal (after you have run it)');

switch cases
    case 1 %RUN AFTER OPTIMAL ONLY
    variance_dynare;
    dr_opt.vc=tot_var;% i.e. variance-covariance in the order of lgy2_ computed in variance-dynare
    [Ao,Bo]=dynare_VAR_representation;
    dr_opt.Ao=Ao;
    dr_opt.Bo=Bo;
    dr_opt.lgy2_=lgy2_;
    dr_opt.fname_opt=M_.fname;
    dr_opt.stst=oo_.steady_state;
    save dr_opt.mat dr_opt  -MAT
    otherwise
variance_dynare;    
load dr_opt.mat    
% assign information to base memory (workspace) to be used by later commands
M_=evalin('base','M_');
fname_=evalin('base','M_.fname');
assignin('base','fname_',fname_);
lgy_=evalin('base','M_.endo_names');
assignin('base','lgy_',lgy_);
dr_=oo_.dr;
Sigma_e_=M_.Sigma_e;

ys_=dr_opt.stst;
lgy2_=lgy_(dr_.order_var,:); % variables as appear in the canonical VAR rapresentation
[xx,alpha_ord]=sort(dr_.order_var);

for jj=1:size(dr_opt.lgy2_,1);
    eval([dr_opt.lgy2_(jj,:),'=',num2str(ys_(jj),11),';']);
end;
eval(['load ',[dr_opt.fname_opt,'_variables.mat']]);


pos_n=[];
xx=[];
zz=1;
for jj=1:size(vary,1);
    xx=(find_incell(str2cell(lgy2_),['\<',deblank(vary{jj}),'\>']));
    if ~isempty(xx)
        pos_n(zz,1)=(xx);
        zz=zz+1;
    end
end
xx=[];
pos_lagr=[];
zz=1;
for jj=1:size(lagnam,1);
    xx=(find_incell(str2cell(dr_opt.lgy2_),['\<',deblank(lagnam{jj}),'\>']));
    
    if ~isempty(xx)
    
        pos_lagr(zz,1)=(xx);
        zz=zz+1;
    end
end
% extr_n=eye(size(lgy2_,1));
% extr_n=extr_n(pos_n,:);

extr_lagr=eye(size(dr_opt.lgy2_,1));
extr_lagr=extr_lagr(pos_lagr,:);

extr_n=eye(size(lgy_,1));
extr_n=extr_n(pos_n,:);
dr_opt.extr_lagr=extr_lagr;
[lgm_m1c,pos_s]=lq_fo_varcov_lagr(A_var,[],[],[],dr_opt,lgy2_,extr_n);




nam_cum_pol=[dr_opt.fname_opt];
eval(['Jft_p1_',nam_cum_pol])  
compensation=1/nbeta*(vec(lgm_m1c(1:size(Jft_p1,1),:))'*vec(Jft_p1));
fprintf('Compensation for timeless perspective %5.5f \n',compensation)

end
