%x=cell2str(m,c);
% transforms the cell m of strings into the column (c=1) or row (c=0) list
% of strings; m must be 1xn or nx1;
% G. Lombardo August 2006

function x=cell2str(m,c);
if nargin==1;
    c=1;
end
szm=size(m);
if szm(1)>1 & szm(2)>1;
    disp('cell has wrong dimension: must have either multiple rows or multiple columns');
end
x=[];
if c~=0

    for jj=1:max(szm);
        if isempty(m{jj})
            tmp='NaN';
        else
            if ischar(m{jj})
            tmp=char(m{jj});
            elseif isnumeric(m{jj})
            tmp=num2str(m{jj});
           else 
               tmp=m{jj};
            end
        end
        x=strvcat(x,char(tmp));
    end
else
    for jj=1:max(szm);
         if isempty(m{jj})
            tmp='NaN';
        else
           if ischar(m{jj})
            tmp=char(m{jj});
           elseif isnumeric(m{jj})
            tmp=num2str(m{jj});
           else 
               tmp=m{jj};
            end
         end
         if ischar(tmp)
             tmp=deblank(tmp);
         elseif issym(tmp)
             tmp=char(tmp);
         end
        try
        x=[x,',',(tmp)];
        catch
            keyboard
        end
    end
    x=['[',x(2:end),']'];
end