% plot chang in shares
function [aver]=change_sh_plot(TN,element,prnt,title_,lab);
if nargin<5;
    lab='';
end
tabs=fields(TN);
tabs=tabs(4:end);
sheername=regexprep(tabs,'(?<=[\_|0-9*])[\w|\_|0-9]*','');% decide what to eliminate from the name string

[a,ii,rep]=unique(sheername);
rand('seed',989777);
colors=rand(1,3);
for jj=2:length(rep);
    if rep(jj)==rep(jj-1);
        colors(jj,:)=colors(jj-1,:);
    else
        tmp=rand(1,3);
        colors(jj,:)=min([0.95,0.95,0.95],(tmp+0.05));
    end
end
trad_sh=[];
for jj=1:length(tabs);
    trad_sh(jj,1)=eval(['TN.',tabs{jj},element,';']);
end

obs=regexp(tabs,'([0-9]*)\>','match');

aver=struct('Mean_share','value');
for kk=1:length(sheername)
    [x,y]=find_incell(tabs,sheername{kk});
    eval(['aver.',sheername{kk},'=mean(trad_sh(y,:));']);
    
end

for kk=1:size(obs,1);
sheername{kk}=[sheername{kk},char(obs{kk})];
end

% [x,y]=sort(sheername);
tabs=regexprep(sheername,'\_','-');% this to give shorter names but might be imprecise: comment it out if labels see odd
% [1:length(trad_sh)]'
figure;h=bar([1:length(trad_sh)],[trad_sh]');
set(get(h,'children'),'FaceVertexCData',colors);
set(get(h,'Parent'),'XTick',[1:length(tabs)]);
set(get(h,'Parent'),'XTickLabel',tabs');
set(gca,'YGrid','on');
tmp=eval(['max',element]);
title([regexprep(title_,'\_','\\_'),' :', TN.demand_labels{tmp}]);
for jj=1:length(rep);
text(jj,trad_sh(jj)+0.01,tabs{jj},'FontSize',8,'Rotation',90);
end
axis tight

set(get(h,'Parent'),'FontSize',8)
xticklabel_rotate

% prnt=input('Print Figure? (0[default]/1) --> ');
% if isempty(prnt);prnt=0;end
if prnt==1
    tmp2=regexprep(deblank(TN.demand_labels{tmp}),'\s*','');
    if ~exist('figures','dir');mkdir('figures');end
    print(gcf,'-deps2c',['figures/',title_,'_',tmp2,'_',lab,'.eps']);
    system(['epstopdf ',['figures/',title_,'_',tmp2,'_',lab,'.eps']]);
    saveas(gcf,['figures/',title_,'_',tmp2,'_',lab,'.fig'])
end

labs=regexprep(fields(aver),'\_','');
vals=struct2cell(aver);
labs=labs(2:end,:);
vals=cell2mat(vals(2:end,:));
[vals,y]=sort(vals);
labs=labs(y,:);
figure;h=bar([1:length(vals)],[vals]);
set(get(h,'Parent'),'XTick',[1:length(vals)]);
set(get(h,'Parent'),'XTickLabel',labs');
set(gca,'YGrid','on');

title([regexprep(title_,'\_','\\_'),' : ', TN.demand_labels{tmp}]);
for jj=1:length(vals);
text(jj,vals(jj)+0.01,num2str(vals(jj),2),'FontSize',10,'Rotation',90);
end
axis tight
set(get(h,'Parent'),'FontSize',10)
xticklabel_rotate

% prnt=input('Print Figure? (0[default]/1) --> ');
% if isempty(prnt);prnt=0;end
if prnt==1
    tmp2=regexprep(deblank(TN.demand_labels{tmp}),'\s*','');
    if ~exist('figures','dir');mkdir('figures');end
    print(gcf,'-deps2c',['figures/average_',title_,'_',tmp2,'_',lab,'.eps']);
    system(['epstopdf ',['figures/average_',title_,'_',tmp2,'_',lab,'.eps']]);
    saveas(gcf,['figures/average_',title_,'_',tmp2,'_',lab,'.fig'])
end
