% uses dynare ++ dynar_simul_ to simulate series at third order

function r = dynare_simul_matlab(oo_,M_,options_,shocks)
y_=oo_.steady_state;
dr=oo_.dr;
if nargin<4
ex_=oo_.exo_simul;
else
    ex_=shocks;
end
  [err, y_] = dynare_simul_(3,M_.nstatic,M_.npred,M_.nboth,M_.nfwrd,M_.exo_nbr, ...
                                  y_(dr.order_var,1)*0,ex_',M_.Sigma_e,options_.DynareRandomStreams.seed,0*dr.ys(dr.order_var),...
                                  dr.g_0,dr.g_1,dr.g_2,dr.g_3);
                              

r(dr.order_var,:)=y_;

save dynare_run.mat oo_ M_ options_ ex_ -MAT
end