%% FIND COOPERATIVE EQUILIBRIUM

%First run to parse
clear all
close all
warning('off')
global kappa_MPc kappa_MPe doloop
kappa_MPc=0.01;
kappa_MPe=0.01;
doloop=0;
dynare GB noclearall;
pos_UE=find_incell(M_.endo_names,'\<UE\>');
pos_UC=find_incell(M_.endo_names,'\<UC\>');
pos_Util=find_incell(M_.endo_names,'\<Util\>');
pos_lambda_e=find_incell(M_.endo_names,'\<lambda_e_MaP\>');
pos_lambda_c=find_incell(M_.endo_names,'\<lambda_c_MaP\>');
pos_Ce=find_incell(M_.endo_names,'\<Ce\>');
pos_Cc=find_incell(M_.endo_names,'\<Cc\>');
pos_R_b=find_incell(M_.endo_names,'\<R_b\>');
pos_R_c=find_incell(M_.endo_names,'\<R_c\>');
positions=[pos_UE;pos_UC;pos_Util;pos_lambda_e;pos_lambda_c;pos_R_b;pos_R_c];

pos_param1=find_incell(M_.param_names,'\<kapa_MPe\>');
pos_param2=find_incell(M_.param_names,'\<kapa_MPc\>');


%% load results from simulation 

d=dir('simul_output/*.mat');
[dx,dx] = sort([d.datenum],'descend');
newest = d(dx(1)).name;
eval(['load simul_output/',newest]);
for jj=1:size(results,3);
    eval(['results',num2str(jj),'=results(:,:,',num2str(jj),');']);
end
%% serch for equilibrium and plot
parallel_plot_part
pr=input('Save Equilibrium Figure? (give additional tag if yes)  ','s');
if ~isempty(pr)
    nm=['welf_Ladje',regexprep(num2str(varphi_Le),'\.','p'),'_and_c_',regexprep(num2str(varphi_Le),'\.','p'),'_BGG',regexprep(num2str(mu),'\.','p'),'_TaylorMP_MaPcost',regexprep(num2str(MP_cost2),'\.','p'),'_and_',regexprep(num2str(MP_cost1),'\.','p'),'_',pr];
    
    
    graph2imwrite(4,nm,'jpg',100,12)
    
    disp(['Saved figure ', nm,' in subfolder figures'])
end