function x = gauss_elim(A,b)
% function x = gauss_elim(A,b)
% this function solves the linear system Ax=b using Gaussian
% elimination WITHOUT pivoting
%
% inputs: A, an n x n matrix
%         b, an n x 1 vector
% 
% output: x, an n x 1 vector which satisfies Ax = b
%
% note in practice, one doesn't actually form the augment matrix
% because we don't want to store it.  Instead, we work on the
% matrix A and vector b simulatneously  

% get size of matrix A
n = length(A);


% forward elimination
for i = 1:n-1
  for j = i+1:n
    % calculate scale factor
    m = A(j,i)/A(i,i);
    % perform row operation
    A(j,:) = A(j,:) - m*A(i,:);
    b(j) = b(j) - m*b(i);
  end
end


% initialize our solution vector
x = zeros(n,1);

% backward substitution
x(n) = b(n)/A(n,n);

for i = n-1:-1:1
  x(i) = (b(i) - A(i,i+1:n)*x(i+1:n))/A(i,i);
end
