% SIMPMLY COMPUTE WELFARE GAINS FOR THE BASELINE CASE
% ONLY THING THAT IS RECOMPUTED IS TAXES: HENCE COMMENT THEM OUT in
% param_GB.m; also need to comment out nash_param for the computation of
% steady state taxes
% USE generate_welfare_table_SDLT_WELFUNITS.m for loops
clear all
clear
global ffr nash_param kappa_MPc kappa_MPe kappa_e kappa_c balbg rams Nash verbose tau_k_e_obj tau_k_c_obj uu_h
uu_h=1;
coop_weight=1;% this parameter rescales uu_h in the cooperative case.
ffr=1;
param_GB;
if ~isempty(tau_k_e_obj)
    error('Comment out taxes')
end
balbg=0;
verbose=[];
coop_model=['dynare GB_subsidy_optimal_SDLT noclearall'];
%% NASH
rngzz=[1:0.05:1.2];
for zzcnt=1:length(rngzz)
    uu_h=rngzz(zzcnt)
nash_param=0;
find_optimal_TAXES_steady_state

if abs(fval)>1e-9
    error('Residual too large')
end
BN=0;% if BN decomposition (The BN is useful only for testing: must have all elements in welfare not only cyclical term)
dynare GB_subsidy_optimal_SDLT noclearall
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% this block evaluates the (un)conditional expectation of variables 
cond_mom_dyn4(0,BN) % first run conditioning on the steady state
save oo_opt_bl1.mat oo_ M_ -MAT % Save the results which include the ergodic unconditional mean
rehash % update -- MATLAB suggested procedure 

save_oo_(1); % This updates the names of things as necessary

cond_mom_dyn4(1,BN) % NOW RE-COMPUTE MOMENTS conditioning on the ergodic mean
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pos_UC=find_incell(M_.endo_names,'UC');
pos_UE=find_incell(M_.endo_names,'UE');
pos_Util=find_incell(M_.endo_names,'Util');
positions=[pos_Util;pos_UE;pos_UC];
%             pos_Ce=find_incell(M_.endo_names,'Ce');
%             pos_Cc=find_incell(M_.endo_names,'Cc');

results{1,1}=oo_.mean(positions)';%/std_Ac^2;

results_disc{1,1}=oo_.mean_disc(positions)';%/std_Ac^2;
restst{1,1}=oo_.steady_state(positions)';
tax_res{1,1}=[tau_k_e_obj,tau_k_c_obj];

%% COOP

clear oo_ M_

nash_param=1;
%  tau_k_e_obj =-0.5600;
%  tau_k_c_obj =-0.5300;
find_optimal_TAXES_steady_state
if abs(fval)>1e-9
    error('Residual too large')
end
eval(coop_model)
%             cond_mom_dyn4(0)
%             save oo_opt_bl1.mat oo_ M_ -MAT % The numerical term in the name must match the input of save_oo_();
save_oo_(1); % this line renames initial conditions appropriately
cond_mom_dyn4(1,BN)
pos_UC=find_incell(M_.endo_names,'UC');
pos_UE=find_incell(M_.endo_names,'UE');
pos_Util=find_incell(M_.endo_names,'Util');
%             pos_Ce=find_incell(M_.endo_names,'Ce');
%             pos_Cc=find_incell(M_.endo_names,'Cc');
positions=[pos_Util;pos_UE;pos_UC];

results{2,1}=oo_.mean(positions)';%/std_Ac^2;

results_disc{2,1}=oo_.mean_disc(positions)';%/std_Ac^2;
restst{2,1}=oo_.steady_state(positions)';
tax_res{2,1}=[tau_k_e_obj,tau_k_c_obj];


taxes=cell2mat(tax_res);
%Welfare needs to be rescaled by (1-discount factor) to have it per unit
%of time
Welfare_hat=cell2mat(results_disc)*(1-nbeta);
% steady state of unilities
stst=cell2mat(restst);
% Welfare level (deviation + steady state)
Welfare=Welfare_hat+stst;
%  Since preferences are logs, the consumption unit is the same as welfare
%  unit. Note that since they are log, the difference is log(1+factor)=~
%  factor
%% Gains are measured as follows:
%% what is the gain of moving from Nash to Coop as compared to moving from Nash to Nash?
Gain(zzcnt,:)=(Welfare(2,:)-Welfare(1,:))*100;%
taxes_all(zzcnt,:)=taxes(:)';
zzcnt=zzcnt+1;
end
% print them out
for jj=1:size(Gain,1)
fprintf('Gains %3.5f (W) %3.5f (E) %3.5f (C)\n',Gain(jj,:))
fprintf('Under Taxes (coop): %3.5f (E) %3.5f (C)\n',taxes_all(jj,2:2:end))
fprintf('Under Taxes (Nash): %3.5f (E) %3.5f (C)\n',taxes_all(jj,1:2:end))
disp('***********************************************************')
end
tb=tabtex({'Pareto Weights','G','E','C'},[],2,[rngzz',Gain])
