function graph_set_linestyle(nfig,linestyle,lnw,mkstyle,color)
% input: (nfig,linestyle,lnw,mkstyle,color)
%        cell with styles (as many as lines in each subplot) eg {':','--',':-','-'}

% if nargin<3 || isempty(lnw)
%     lnw=0.5;
% end
figure(nfig);
gcf;
if ~isempty(linestyle)
    nlines=length(linestyle);
elseif ~isempty(mkstyle)
    nlines=length(mkstyle);
elseif ~isempty(color)
    nlines=length(color);
else
    error('At least one of the inputs must be a cell (mat) of property values');
end
ch=findobj(nfig,'-property','Marker');

% ch=ch(end:-1:1);
iii=length(ch);
z=1;
try
    while z<=iii
        
        for kk=1:nlines
            
            if isprop(ch(z),'LineStyle')
                
                if ~isempty(linestyle)
                    if length(linestyle)~=nlines
                        error('For each property need as many entries as # lines')
                    end
                    set(ch(z),'LineStyle',linestyle{kk})
                end
                if ~isempty(lnw)
                    if length(lnw)~=nlines
                        error('For each property need as many entries as # lines')
                    end
                    set(ch(z),'LineWidth',lnw(kk))
                end
                if nargin>3&& ~isempty(mkstyle)
                    if length(mkstyle)~=nlines
                        error('For each property need as many entries as # lines')
                    end
                    set(ch(z),'Marker',mkstyle{kk})
                end
                if nargin>4 &&~isempty(color)
                    if length(color)~=nlines
                        error('For each property need as many entries as # lines')
                    end
                    set(ch(z),'Color',color{kk})
                end
                
                
                
            end
            
            z=z+1;  % F. Matlab seems to have changed the sequence of lines in object: this affects where to advance z
        end
        
    end
catch erro
    disp(erro)
    keyboard
end
