% re-set position
% of subplots so to alline them
% inputs: number of figure
%         vector of rows and columns [can be different from original
%         although prod(rc)=original
%         cell with optional Y-axis labels
%         rotation of label
% Output: No output, just new plot
function graph_set_subplot_positions(numfig,rc,ylab,rot,xaxis,nmsave)
if nargin<4
    rot=0;
    xaxis=0;
elseif nargin<5
    xaxis=0;
end
h=get(figure(numfig));
% if nargin<2
%     n=1;
% end
% position_0=get(h.Children(n),'Position');
% % h=get(figure(1)); should pass h
% for jj=1:length(h.Children)
% position=get(h.Children(jj),'Position');
% set(h.Children(jj),'Position',[position(1:2),position_0(3:4)])
% end
%
r=rc(1);
c=rc(2);
h_ = h.Children; % assuming nothing else on screen
h_=findobj(h_,'XGrid','off');
totfig=r*c;
h_=h_(end-totfig+1:end,1);
lastrow=totfig-c+1;
% Step 2: Use subplot in scratch figure to figure out new position
fig2 = figure;
for i=1:length(h_)
    figure(fig2); % Make sure fig2 is active
    g = subplot(r, c, i);
    set(h_(length(h_)-i+1), 'Position', get(g, 'Position')); % Reposition h(i)
    set(h_(length(h_)-i+1),'XGrid','off');
    set(h_(length(h_)-i+1),'YGrid','off');
    set(h_(length(h_)-i+1).XLabel,'String','');
    set(h_(length(h_)-i+1),'LineWidth', [1]);
    tt=get(h_(length(h_)-i+1),'XTick');
    if xaxis~=1 && i<lastrow
        set(h_(length(h_)-i+1),'XTickLabel','')
    else
        if length(tt)>20
            set(h_(length(h_)-i+1),'XTick',[min(tt):4:max(tt)]);
        end
    end
    if i<=(r*c-c)
        hax2=h_(length(h_)-i+1);
        hh=get(hax2,'Children');
        for uu=1:length(hh);
            if isprop(hh(uu),'String')
                set(hh(uu),'String','');
            end
        end
    end
end

if nargin>=3
    if ~isempty(ylab)
        if length(ylab)~=r
            disp('list of labels must be equal to rc(1)');
            return
        end
        z=1;
        for jj=length(h_):-c:1
            
            set(get(h_(jj),'YLabel'),'String',ylab{z},'Rotation',rot);
            z=1+z;
        end
    end
end

delete(fig2);
if nargin==6;
    if ~isempty(nmsave)
        if ~ischar(nmsave)
            namepri=input('Name to save figure [blank to skip] => ','s');
            if ~isempty(namepri)
                saveas(figure(numfig),['figures/',namepri,'.fig'])
                orient(figure(numfig),'landscape')
                print(figure(numfig),'-dpdf',['figures/',namepri,'.pdf'])
                print(figure(numfig),'-depsc2',['figures/',namepri,'.eps'])
            end
        end
    end
end