% function [dd]=lev2exp(equain,varnames);
%This code takes in one (string) equation at a time (in Dynare notation)
%and the (column) vector of the names of the variables. It returns the same
%equation with variable names replaced by exp(variable name).
% it takes care of the lead and lag indexes (default is 5, if more must
% amend maxlaglead below).
% 1 September 2005 -- giovanni.lombardo@ecb.int
function [dd]=lev2exp(equain,varnames,maxlaglead,nsh,varargin);
dd=[];
varnames=str2cell(varnames);
% keyboard
lsnolog=input('Give list {''x'',...etc} of variables to keep in levels  ');
gg=[];
if ~isempty(lsnolog)
    lsnolog2=lsnolog(:);
    for kk=1:max(size(lsnolog))
        lsnolog2{end+1,1}=[deblank(lsnolog{kk}),'_plus1'];
    end
        for kk=1:max(size(lsnolog))
        lsnolog2{end+1,1}=[deblank(lsnolog{kk}),'_minus1'];
    end

    for jj=1:max(size(lsnolog2))
        tmp=find_incell(varnames,['\<',deblank(lsnolog2{jj}),'\>']);
        if isempty(tmp)
            fprintf('variable %s in list does not exist\n',lsnolog2{jj})
            return
        else
            gg(jj,1)=tmp;
        end
    end

    
end
    disp('list of excluded variables from log-transformation')
    disp(varnames(gg,:))
    logvar=setdiff([1:size(varnames,1)]',gg);
    varnames=cell2str(varnames(logvar,:));
    bb=[];
    for kk=1:max(size(lsnolog));
        bb{kk,1}=[lsnolog{kk},'=exp(',lsnolog{kk},');'];
    end
    disp('Copy and paste this in the steadystate file');
    disp(char(bb));
    disp('PRESS ENTER TO CONTINUE')
    pause

%  keyboard
%maxlaglead=2;
%keyboard
nvar=size(varnames,1);
neq=size(equain,1);
equash=equain(end-nsh+1:end,:);
equain=equain(1:end-nsh,:);
dd=equain;
% if ~iscell(varnames)& nvar>1
%     varn_old=varnames;
%     varnames=cell(nvar,1);
%     for jj=1:nvar
%         varnames{jj,1}=varn_old(jj,:);
%     end
% end
for jj=1:nvar;
dd=regexprep(dd,['\<',deblank(varnames(jj,:)),'\>+'],['exp\(',deblank(varnames(jj,:)),'\)']);
dd=regexprep(dd,['\<',deblank(varnames(jj,:)),'_ss\>+'],['exp\(',deblank(varnames(jj,:)),'_ss\)']);

%dd=strrep(dd,')_s','_s)');
dd=strrep(dd,'exp(exp','(exp');
end
for kk=1:2
for jj=1:maxlaglead;
    dd=strrep(dd,[')(+',num2str(jj),')'],['(+',num2str(jj),'))']);
    dd=strrep(dd,[')(-',num2str(jj),')'],['(-',num2str(jj),'))']);
end
end
% keyboard
ff=cell(neq,1);
ff(1:size(dd,1),:)=dd;
ff(size(dd,1)+1:end,1)=equash;
dd=ff;
return