% myfortran
% F=myfortran(M,nmM) takes the matrix M and a name 'nmM' and returns the
% matrix entries nmM(i,j)=xx as cells
% Use char(nmM) to turn the cells into text (e.g. for saving).
% Giovanni.Lombardo@ecb.int 2005
function F=myfortran(M,nmM,varargin)
if isempty(varargin)
    truefort=0;
else
    truefort=varargin{1};
end
F=[];%cell(nn,1);
z=1;
if ~truefort
    if ~ischar(M)&~iscell(M)
        M=sym(M);
        charM=0;
        szm=size(M);
        nzm=M(M~=0);
%         nn=sum(sum(nzm));
        nn=prod(size(nzm));% changed on 2 Apr. 2014 for consistency with Matlab 2012b
    else
        charM=1;
        szm=[size(M,1),1];
        nzm=0;
        nn=0; %change checking of zeros
    end
else
    charM=0;
    szm=size(M);
%     nzm=(M~=0);
%     nn=sum(sum(nzm));
        nzm=M(M~=0);

        nn=prod(size(nzm));
end

if charM==0
    for j=1:szm(1)
        for i=1:szm(2)
            if M(j,i)~=(0)
                if truefort
                    %                     F{z,1}=[nmM,'(',num2str(j),',',num2str(i),')=',...
                    %                         regexprep(char(vpa(M(j,i),17)), '\^', '**','ignorecase'),';'];
                    if ~isreal(M(j,i));
                        tmp_r=real(M(j,i));
                        tmp_i=imag(M(j,i));
                        F{z,1}=[nmM,'(',num2str(j),',',num2str(i),')=cmplx(',num2str(tmp_r,15),',',num2str(tmp_i,15),');'];
                    else
                        F{z,1}=[nmM,'(',num2str(j),',',num2str(i),')=',num2str(M(j,i),15),';'];
                    end
                else
                    F{z,1}=[nmM,'(',num2str(j),',',num2str(i),')=',...
                        char((M(j,i))),';'];%simplify
                end
                z=z+1;
            end
        end
    end
else
    h= waitbar(0,['Please wait...substituting']);
    
    
    % if M is a vector of strings
    for j=1:szm(1)
        waitbar(j/szm(1),h,['Please wait...fortranizing ',num2str(j),' of ',num2str(szm(1))])
        
        
        if truefort
            F{z,1}=[nmM,'(',num2str(j),',',num2str(1),')=',...
                regexprep(char((M(j,:))), '\^', '**','ignorecase'),';'];
        else
            F{z,1}=[nmM,'(',num2str(j),',',num2str(1),')=',...
                char((M(j,:))),';'];%simplify
            
        end
        z=z+1;
    end
    close(h)
end

%F=char(F);
