% ols estimation:
% inputs: dependent variable
%         matrix of regressors (constant is added by default)
%         (optional) switch 1=add constant, 0=noconstant
%         (optional) verbose (1/0)
% output: structure:
%         results.type: 'OLS'
%         results.beta (parameter estimates)
%         results.std  (standard deviation)
%         results.tstat (t-statistic)
%@g.l. ECB 23 Nov. 2007
function [results]=myols(y,x,constant,verbose,labels)


results=struct('type','ols');
obs=length(y);
if size(x,1)~=size(y,1)
    disp(' different number of observations in regressor and regressands')
    return
end

if nargin>2
    if constant==1
        x=[ones(obs,1),x];
    end
else
    x=[ones(obs,1),x];
end

if nargin<4
    verbose=1;
end
bet=(x'*x)\x'*y;

estres=(y-x*bet);

stdest=std(estres);

stdbeta=diag(sqrt(inv(x'*x))).*stdest;
results.beta=bet;
results.std=stdbeta;
results.tstat=bet./stdbeta;
results.pval=1-tcdf(results.tstat,length(y)-length(results.tstat));
results.obs=obs;
%%

% Rsquared



Rsq=1-var(estres)/var(y);

results.Rsq=Rsq;
if verbose
    lab={'constant'};
    for jj=2:length(results.beta);
        if nargin<5
            
        lab{jj,1}=['parameter ',num2str(jj)];
        else
            labels=labels(:);
            lab{jj,1}=labels{jj,1};
        end
    end
    %lab{end+1}='R^2\nobs';
    mytable(lab,{'reg-coeff';'t-stat'},[[results.beta],[results.tstat]],5);
    disp('************************************************************')
    mytable({'=>'},{'R^2';'nobs'},[[results.Rsq],[obs]],5);
end
return
