% turn to log-linear representation of the model
%function [kkk,model_new]=nonlin2linmod(fname);

function [kkk,model_new]=nonlin2linmod(fname);
model_new=[];
kkk=[];
disp('Must have parsed the model with symbsolve first!!!')
[ddd,jjj]=regexp(fname,'\.mod','match');
if isempty(jjj)

    namemod=[fname,'.mod'];
else
    namemod=fname;
    tmp=regexp(fname,'\.');
    fname=fname(1:tmp-1);
end

if ~exist(namemod)
    disp(['file ', namemod,' not found']);
    return
end
eval(['load matrices_',fname]);
if isfield(matrices,'linearmod');

    linear_model=(matrices.linearmod);
    lgy_=matrices.varyt;
    ss_tag=input('Give extension for steady-state variables (default=_ss)','s');
    if isempty(ss_tag);
        ss_tag='_ss';
    end
    sslgy_=[];
    for jj=1:size(lgy_,1);
        sslgy_{jj,1}=[deblank(lgy_(jj,:)),deblank(ss_tag)];
    end
    ssvars=['parameters ',regexprep(cell2str(sslgy_,0),'\[|\]',''),';'];
    if isempty(linear_model)
        disp('No linear model in output of symbsolve: run symbsolve first asking for symbolic model');
        return
    end
else
    disp('No linearmod field in symbsolve output: run symbsolve first asking for symbolic model');
    return
end
linear_model=(sym2cell(linear_model));
linear_model=mine2dyn(linear_model,1);
kkk=[];
for jj=1:size(linear_model,1);
    kkk{jj,1}=[deblank(linear_model{jj}),'=0;'];
end
kkk=char(kkk);
%%%%%%%%%%%%%%%%%%%% search model block
model=(textread(namemod,'%s','bufsize',1000000,'delimiter','\n'));

modstrt=find_incell(model,'^model|(?<!(\S\s*))(model)');

modend=modstrt+find_incell(model(modstrt:end,:),'^end|(?<!(\S\s*))(end)');

parastrt=find_incell(model,'^parameters|(?<!(\S\s*))(parameters)');
[paraend]=find_incell(model(parastrt:end,:),';');

paraend=parastrt+paraend-1;
%%%%%%%%%%%%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% search exogenous processes
% 
% shockstrt=find_incell(model,'\\\\\s*(Exogenous)');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% search call to steady;
% 
 sscall=find_incell(model,'\s*(\<steady\>)');


%%%%%%%%%%%%%%%%%%%% other files

model=char(model);
% tmp=strvcat(model(1:modstrt,:),kkk,model(modend:end,:));
%%%%%%%%%%%%%%%%%%%5
disp('__________________________________________')
disp('THE LINEAR BLOCK IS IN variable char(kkk)')
disp('__________________________________________')
disp('PRESS ANY KEY TO CONTINUE WITH GENERATING A LINEAR MODEL');
disp('!! ENTER Y to exit !!')
disp('__________________________________________')
ext=input('=======>> ','s');
if strcmpi(ext,'Y');
    return
end

%%%%%%%%%%%%%%%%%%

tmp=strvcat(model(1:paraend,:),'//New parameters (ss values);',ssvars,...
    '//EQUATIONS;','model(linear);',kkk,'end;','//;',model(modend:sscall-1,:),[fname,'_linear_steadystate;'],model(sscall+1:end,:));

dirname=[pwd,'/',fname,'_linear_dir'];
if ~exist([dirname],'dir');
    
    mkdir(dirname);
end



if ispc
    [xx,xy]=system(['copy ',fname,'_steadystate.m ',dirname, '/',fname,'_linear_steadystate.m']);
else
    [xx,xy]=system(['cp ',fname,'_steadystate.m ',dirname,'/',fname,'_linear_steadystate.m']);
end

if 0  %this can take too long
if exist([fname,'_steadystate'],'file');
    
tmp2=depfun([fname,'_steadystate'],'-quiet', '-toponly');
[a,b]=find_incell(tmp2,pwd);
end
for jj=2:length(b);
        tmp0=char(tmp2(b(jj),:));
        ntmp=regexp(tmp0,'/');
        ntmp2=(tmp0(1,ntmp(end)+1:end));
    if ispc

        [xx,xy]=system(['copy ',ntmp2,' ',dirname, '/',ntmp2]);
    else
        [xx,xy]=system(['cp ',ntmp2,' ',dirname,'/',ntmp2]);
    end
end
end

fid=fopen([dirname,'/',fname,'_linear.mod'],'w+');
fprintf(fid,'%s\n',['% New version updated: ',datestr(now),';']);
fclose('all');
fid=fopen([dirname,'/',fname,'_linear.mod'],'a+');
for ddd=1:size(tmp,1);

    fprintf(fid,'%s\n',[deblank(tmp(ddd,:))]);

end
fclose('all');





disp('DONE')
fprintf(['The .mod file and _steadystate file are in the subdirectory\n %s:\n',...
    'Copy all other relevant file into this directory\n and the model should be ready to run\n'], dirname);
disp('$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$')

fprintf(['Fix the ''..._steadystate'' file in the following way:\n'...
    '1)\t look for assignment of output vector (ys?) and assign it to zero\n'...
    '2)\t look for assignment of steady state variables (e.g. _ss) and assign the log-value of the variable\n'...
    '3)\t Need to copy manually the shock processes if the linearization messed them up (innovations will be missing)\n'])
disp('$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$')
return