% for a multiple tensor product of two vectors of symbols
% returns the compact representation of cross products (i.e. w/o
% repetitions).
%  changed on 28 Jan. 2013 to take the upper part instead of lower part
function [S,w,v2]=order_vecX_up(V2)

[l,jj,ii]=unique(sym2cell(V2),'first');
S=sparse(eye(length(V2)));
W=sum(S(ii,ii));
S=S(sort(jj),:);
S=S(end:-1:1,end:-1:1);
w=W(sort(jj));
w=w(end:-1:1);
if nargout>2
v2=w'.*(S*V2);
end
end