% PARALLEL PLOT PART
%% finding equilibria and plot
close all
% cooperative
range1=rangeB;% HOME COUNTRY
range2=rangeA;% FOREIGN COUNTRY
A=rangeB;
B=rangeA;
%%%% Eliminate non-feasible equilibria
% FIND MaPs that violate inequality constraint (no zero-rate loans)
tau_e=(results4+oo_.steady_state(pos_tau_e));
tau_c=(results5+oo_.steady_state(pos_tau_c));

[ii_subs]=find(~((tau_e(:)<=1+1e-5).*(tau_c(:)<=1+1e-5)));
WelfareMx=results3(:);
WelfareMx(ii_subs)=NaN;
WelfareMx=reshape(WelfareMx,size(results3));

WelfH=results1(:);
WelfH(ii_subs)=NaN;
WelfH=reshape(WelfH,size(results1));

WelfF=results2(:);
WelfF(ii_subs)=NaN;
WelfF=reshape(WelfF,size(results2));

%%% THIS PIECE OF CODE FINDS EQUILIBRIA
plot_nash;

%%% get transparency for NaN
WelfH=results1;
WelfF=results2;
WelfareMx=results3;

TT=ones(size(WelfareMx))*.1;
TT=TT(:);
TT(ii_subs)=0;
TT=reshape(TT,size(WelfareMx));
%%%%%%% PLOT MaP
figure(1); %plot MaP as function of MaP coefficients
mesh(B,A,tau_e,'FaceColor',[1,1,1],'EdgeColor',[1,0,0],'FaceAlpha',0,'EdgeAlpha',1,'LineStyle','--')
hold on;
surf(B,A,tau_c,'FaceColor',[1,1,1],'EdgeColor',[0,0,1],'FaceAlpha',0,'EdgeAlpha',1)

legend('\tau_{k}^e','\tau_{k}^c')
surf(B,A,ones(size(results5)),'FaceColor',[0,.2,0],'EdgeColor',[0,1,0],'FaceAlpha',0.2,'EdgeAlpha',0.00)
xlabel('\kappa_{MaP}^c')
ylabel('\kappa_{MaP}^e')



% % % PLOT INTEREST RATE
figure(2);
mesh(B,A,results6,'FaceColor',rgb2gray([1,0.6,0.7]),'EdgeColor',[1,0,0],'AlphaData',TT*.5,'FaceAlpha','interp','EdgeAlpha',1,'LineStyle','--')
hold on;
mesh(B,A,results7,'FaceColor',rgb2gray([0.7,0.6,1]),'EdgeColor',[0,0,1],'AlphaData',TT,'FaceAlpha','interp','EdgeAlpha',1)
legend('R_b','R_c')
xlabel('\kappa_{MaP}^c')
ylabel('\kappa_{MaP}^e')

% % % PLOT WELFARE
figure(3);
mesh(B,A,WelfH,'FaceColor',rgb2gray([1,0.8,0.7]),'EdgeColor',[1,0,0],'AlphaData',TT*0.5,'FaceAlpha','interp','EdgeAlpha',1,'LineStyle','--')

hold on
mesh(B,A,WelfF,'FaceColor',rgb2gray([0.7,0.8,1]),'EdgeColor',[0,0,1],'AlphaData',TT,'FaceAlpha','interp','EdgeAlpha',1) %,'FaceAlpha',.9
legend('Welfare EME','Welfare Center')
xlabel('\kappa_{MaP}^c')
ylabel('\kappa_{MaP}^e')
figure(4);
% [ii,jj]=find(results3==max(max(results3)));
hh=plot3(B(jjcoop),A(iicoop),WelfareMx(iicoop,jjcoop),'or','MarkerSize',10,'MarkerFaceColor',[1,0,0]);
%text(B(jjcoop),A(iicoop),results3(iicoop,jjcoop),sprintf('Cooperative eq %2.2f %%',results3(iicoop,jjcoop)*100),'FontSize',12,'FontWeight','bold','Rotation',20)
hold on
hh=plot3(B(equil(2)),A(equil(1)),WelfareMx(equil(1),equil(2)),'sr','MarkerSize',10,'MarkerFaceColor',[0,0,1]);
mesh(B,A,WelfareMx,'FaceColor',rgb2gray([0.8,1,.8]),'EdgeColor',[0,1,0],'AlphaData',TT*0.2,'FaceAlpha','interp','EdgeAlpha',1)
grid on
%text(B(equil(2)),A(equil(1)),results3(equil(1),equil(2)),sprintf('Nash eq %2.2f %%',results3(equil(1),equil(2))*100),'FontSize',12,'FontWeight','bold','Rotation',20)
legend(sprintf('Cooperative eq %2.2f %% @(%2.2f,%2.2f)',WelfareMx(iicoop,jjcoop)*100,iicoop,jjcoop),sprintf('Nash eq %2.2f %%  @(%2.2f,%2.2f)',WelfareMx(equil(1),equil(2))*100,equil(1),equil(2)))
xlabel('\kappa_{MaP}^c')
ylabel('\kappa_{MaP}^e')
title('Global Welfare')

