function results=parallel_sweep(rA,rB,kk,namefile,parallel_);
global rangeA rangeB
global S1_bar S2_bar doloop M_
results=[];
%% This is the master file to run in parallel simulations across different
%% parameter value sets. NB: after running in parallel, must clear all, otherwise a second run
%% will generate an error (mex-exception). Probably due to Dynare mex files.
% Inputs:   first range
%           Second range
%           Number of workers
%           If parallel computation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin<4;
    disp('must give 5 inputs: range1, range2, #of cores , name of file and if parallel computation (0/1)');
end
%% In the mod file have a switcher doloop for executing one or sevral simulations
doloop=1;
%% number of labs (given as input to this function)
% kk =6;
%% kill possibly open pools
rangeA=rA;
rangeB=rB;
try
    tic
    if parallel_
        pp=gcp('nocreate');
          listatt={'nodes_part.m','BroFiLoWa_GE.mod', [namefile,'_steadystate.m'] ...
            ,'SS_core_sub.m' ...
           };
        if isempty(pp)
        %% configure pool
        c=parcluster('local');
        
        job1 = createJob(c);
         parpool(c,kk,'AttachedFiles',listatt)
        else
             c=parcluster('local');
        
        job1 = createJob(c);
        addAttachedFiles(pp, listatt);
        end
        
        %% list of files to pass files to workers

       
        %% Pass information (paths in this case) =================================== MUST ADJUST THE PATH
        tmp1=regexprep(regexprep(which('dynare'),'\/','\/\/'),'dynare.m','');
        eval(['pctRunOnAll addpath(''',regexprep(tmp1,'\/\/','\/'),''')'])
        tmp2=pwd;
        eval(['pctRunOnAll addpath(''',tmp2,''')'])
        % pctRunOnAll addpath('/usr/lib/dynare/matlab')
        % pctRunOnAll addpath('/home/calomba/Dropbox/projects/AGKP_growth_credit/BDL_JIMF_submission_ex_version_27')
        
        %% Alternative way to pass path (doesn't seem to work)
        %  ap = {'/home/gianni/dynare-4.4.3/matlab/', ...
        %      '/home/gianni/Dropbox/projects/AGKP_growth_credit/BDL_JIMF_submission_ex_version_27'};
        % job1.AdditionalPaths = ap;
        
        %% Define Range to be split
        
        rangeA=rA; %% <<<<<<<<<<<<<<<<<<<<<<========= RANGE
        
        %% Pass the doloop switch
        pctRunOnAll eval(['global doloop ']);
        pctRunOnAll eval(['doloop=1']);
        %% Define second range (if more dimensions, must adapt preloop.m postloop.m etc.)
        rangeB=rB;
        
        %% Make sure there is at least one point per processor
        kk=min(kk,length(rangeA));
        %% Submit job (contained in the wrapper "nodes_part"
        
        spmd
            % generate distribution of this matrix (i.e. rangeA is subdivided into
            % partitions of equal size distributed over the nodes)
            D = codistributed(rangeA ,codistributor1d(2));
            rangeA_=getLocalPart(D);
            op=nodes_part(rangeA_,rangeB,namefile);
            
        end
        toc
        sz=[];
        for jj=1:size(op,2);
            sz(jj,:)=size(op{jj});
        end
        tmp1=max(sz,[],1);
        tmp2=mean(sz,1);
        tst=tmp1==tmp2;
        catdim=find(1-tst);
        results=cat(catdim,op{:}); % The dimension in the first entry depends on whether have singleton on second dimension or not if yes then 1 if no then 2
       
        eval(['pctRunOnAll rmpath(''',tmp2,''')'])
    else
        cpt=pwd;
        eval(['addpath(''',cpt,''');']);
        op=nodes_part(rangeA,rangeB,namefile);
        results=op;
    end
    %     keyboard
    
%     dlmwrite('parallel_output.dat',results);
catch exception

    keyboard
    exception
    exception.stack.file
    exception.stack.line
    if isfield(exception,'remotecause')
        if iscell(exception.remotecause)
    exception.remotecause{1}
        end
    end
    delete(gcp('nocreate'));
end
%% clean pool
% delete(gcp('nocreate'));
%% Results will be stored in a separate directory
% keyboard
mkdir simul_output
%% Save results with time stamp
date_time=datestr(now,'yyyy_mm_dd_at_hh_MM');
eval(['save simul_output/results_',date_time,'.mat results rangeA rangeB ']);


end