% plot density of priors
% USE:
% plot_density(pshape,p1,p2)
% pshape has to be one of the following cases:
% case 1% Beta prior 
% case 2% Generalized Gamma prior
% case 3% Gaussian prior
% case 4% Inverse-gamma of type 1 prior
% case 5% Uniform prior
% case 6% Inverse-gamma of type 2 prior
% p1=mean
% p2= standard deviation

function plot_density(pshape,p1,p2);

switch pshape
    case 1
        p3=0;
        p4=1;
    case 2
        p3=0;
        p4=inf;
    case 3
        p3=-inf;
        p4=inf;
    case 4
        p3=0;
        p4=inf;
    case 5
        p3=-(3^(1/2)*(3*p2 - 3^(1/2)*p1))/3;
        p4=(3^(1/2)*(3*p2 + 3^(1/2)*p1))/3;
       
    case 6
        disp('Inv-Gamma-2 distribution not implemented')
        return
end
        
    
   
lb=p3;
ub=p4;

M_=evalin('base','M_');
options_=evalin('base','options_');
estim_params_=struct('var_endo',[]);
estim_params_.corrx=[];
estim_params_.corrn=[];
estim_params_.param_vals=[];
estim_params_.var_exo=zeros(1,9);
estim_params_.var_exo(1,1)=1;
estim_params_.var_exo(1,4)=ub;
estim_params_.var_exo(1,3)=lb; 
estim_params_.var_exo(1,5)=pshape;
estim_params_.var_exo(1,6)=p1;
estim_params_.var_exo(1,7)=p2;
estim_params_.var_exo(1,8)=lb;
estim_params_.var_exo(1,9)=ub;
estim_params_.var_exo(1,10)=1;
[xparam1,estim_params_,bayestopt_,lb,ub,M_] = set_prior(estim_params_,M_,options_);
% bayestopt_=struct('pshape',pshape);
% bayestopt_.p3=p3;% lower bound
% bayestopt_.p4=p4; % upper bound
% bayestopt_.p6=p6; % 
% bayestopt_.p7=p7;

[x,f,abscissa,dens,binf,bsup] = draw_prior_density(1,bayestopt_);
hh = plot(x,f,'-k','linewidth',2);
        set(hh,'color',[0.7 0.7 0.7]);
        box on
%         title(nam,'Interpreter','none')
        drawnow
end
        