function b1=plot_hist_normalized(x);

[Values, Edges] = histcounts(x);

% And rescaling:
figure(1984)
scatter(1:length(x(:)),x, 1, 'filled')
ax = gca;
maxlim = max(ax.XLim);
close(1984)

Values = Values / max(Values) * maxlim;

% and finding centres of bars:

bar_centres = 0.5*(Edges(1:end-1) + Edges(2:end));

% Up to release 2014a, bar charts had a 'children' property for the patches that allows transparency to be controlled, e.g.:

% plot histogram
b1 = bar(bar_centres,Values,.5);
% change transparency
% set(get(b1,'Children'),'FaceAlpha',0.3)
b1.FaceAlpha = 0.3;
end