% generate quarterly series out of monthly series
% assumes that the first date is the beginning of a quarter (so partial
% quarters at beginning need to be dealth with manually)
function y=quarterlize(x,dT);
if nargin<2
    dT=1;
end

if dT==1
    dv=3;
else
    dv=1;
end

lnx=size(x,1);
lny=floor(lnx/3);
resln=lnx-lny*3;
zz=1;
for jj=1:3:lny*3;
y(zz,:)=sum(x(jj:jj+2,:),1)/dv;
zz=zz+1;
end
if resln>0
    if dT==1
y(end+1,:)=sum(x(lny*3+1:end,:))/size(x(lny*3+1:end,:),1);
    else
       y(end+1,:)=sum(x(lny*3+1:end,:));
    end
end
return