% re-set position
% of subplots so to alline them
% inputs: handle (e.g. h=get(figure(1)); should pass h)
%         vector of rows and columns [can be different from original
%         although prod(rc)=original
% Output: No output, just new plot
function set_subplot_positions(h,rc,ylab)
% if nargin<2
%     n=1;
% end
% position_0=get(h.Children(n),'Position');
% % h=get(figure(1)); should pass h
% for jj=1:length(h.Children)
% position=get(h.Children(jj),'Position');
% set(h.Children(jj),'Position',[position(1:2),position_0(3:4)])
% end
% 
r=rc(1);
c=rc(2);
h_ = h.Children; % assuming nothing else on screen
h_=h_(end-r*c+1:end);
% Step 2: Use subplot in scratch figure to figure out new position
fig2 = figure;
for i=1:length(h_)
   figure(fig2); % Make sure fig2 is active
   g = subplot(r, c, i);
   set(h_(length(h_)-i+1), 'Position', get(g, 'Position')); % Reposition h(i)
   set(h_(length(h_)-i+1),'XGrid','off')
      set(h_(length(h_)-i+1),'YGrid','off')
      
   
end

if nargin==3
    if length(ylab)~=r
        disp('list of labels must be equal to rc(1)');
        return
    end
    z=1;
    for jj=length(h_):-c:1
        
        set(get(h_(jj),'YLabel'),'String',ylab{z},'Rotation',0);
        z=1+z;
    end
end
        
delete(fig2);