% simulations with Dynare output
% symbsolve utilities
% Giovanni.Lombardo@ecb.int January 2009
%%%%%%%%%%%%%
%% Run Dynare to first order, then run this and get simulations in yfo matrix in M_.endo_names order.
%%%%%%%%%%%%

dr_=oo_.dr;
lgy_=M_.endo_names;
nstat=M_.nstatic;
if isfield(M_,'nspred');% older verisions of Dynare (<4.3.3) had this 
npred=M_.nspred;
else
    npred=M_.npred+M_.nboth;
end;

% Reconstruct VAR representation
A_mx =[zeros(size(lgy_,1),nstat),...
    dr_.ghx,zeros(size(lgy_,1),...
    size(lgy_,1)-npred-nstat)];
B_mx = dr_.ghu;
%%%%%%%%%% generate series  using smoothed shocks
yfo=zeros(size(lgy_,1),1);
Sigma_e=M_.Sigma_e;
hory=2000;
    for jj=2:hory
sh_t0=mvnrnd(zeros(size(Sigma_e,1),1),Sigma_e,1);
        yfo(:,jj)=A_mx*yfo(:,jj-1)+B_mx*sh_t0';
    end
    
    yfo=yfo(dr_.inv_order_var,:);
    
%     pos_R=find_incell(str2cell(lgy_),'\<R\>');
%     
%     RR=exp(yfo(pos_R,:)+log(R));
%     
%     figure;plot([RR;ones(size(RR))]')