%%% generate latex document with tables: see tabtex2texpdf for an
%%% alternative.
function []=tabtex_doc(name,doamble,titlep,header,caption,dig,varargin)
gg=varargin;
if isempty(titlep)|titlep==0
    titlestuff=[];
else
    titlestuff=strvcat('\begin{titlepage}',...
'\title{Your Title}',...
'\author{Your Name\\Affiliation \\ Address\\ E-mail: {}}',...
'\date{\today}',...
' \maketitle',...
' \end{titlepage}',...
'%\tableofcontents',...
'\newpage');
end
tt=tabtex_in_doc(header,caption,dig,gg);
amble=[];
endamble=[];
if doamble==1
    amble=strvcat('\documentclass[12pt,a4paper]{article}%',...
'\usepackage{graphicx}',...
'\usepackage{amsmath}',...
'\usepackage{epsfig}',...
'\usepackage{amsfonts}%',...
'\usepackage{amssymb,longtable,hyperref}',...
' ',...
'\begin{document}');
endamble='\end{document}';
end


pream=strvcat(amble,...
titlestuff,...
table_,...
titlestuff,...
tt,...
endamble);
ccdd=cd;
if ~exist('tex_stuff','dir')
    !md tex_stuff
end
tex_name=name;%input(upper('Give the name of the tex file to save (no extension)'));
tex_name=[cd,'\tex_stuff\',tex_name,'.tex'];
fid=fopen([tex_name],'w+');
if fid<0
    disp('problems with the file: it might be open')
    return
end
fprintf(fid,'%s\n',pream(1,:));
fclose(fid);
for jj=2:size(pream,1)
  fid=fopen([tex_name],'a+');
fprintf(fid,'%s\n',pream(jj,:));
fclose(fid); 
end
% compile
if doamble==1
%cd tex_stuff
dos(['latex -quiet -output-directory=tex_stuff ', [ccdd,'\tex_stuff\',name,'.tex  ']]);
dos(['dvipdfm  -p a4 -r 800  -o ',[ccdd,'\tex_stuff\',name,'.pdf '],[ccdd,'\tex_stuff\',name,'.dvi']]);
end
% -l for landscape

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function tabl=tabtex_in_doc(header,caption,dig,gg);
doheader=1;
if isempty(header)
    doheader=0;
else
    head=[];
    
    for kk=1:size(header,1);
        head=[head,'&',header(kk,:)];
    end
end
if isempty(dig)
    dig=15;
end
ta=[];

hum=['& '
     '\\'];
 semc=[,
       ;];
   sepc1=[];
   sepc2=[];
   for uu=1:size(gg{1},1)
       sepc1=[sepc1;hum(1,:)];
       sepc2=[sepc2;hum(2,:)];
   end
if ischar(gg{1})
   ta=[strvcat(gg{1}),sepc1];
elseif size(gg{1},2)==1
    ta=[num2str(gg{1},dig),sepc1];
else
    ta=[];
    for i=1:size(gg{1},2)-1
        ta=[ta,[num2str(gg{1}(:,i),dig),sepc1]];
    end
    ta=[ta,num2str(gg{1}(:,end),dig)];
end


if length(gg)>1 
for i=2:length(gg)
    if size(gg{i},2)==1
        
        ta=[ta,[num2str(gg{i},dig)]];%,sepc1
      
    else
        for j=1:size(gg{i},2)-1
           
            ta=[ta,[num2str(gg{i}(:,j),dig),sepc1]];
      
        end
         ta=[ta,num2str(gg{i}(:,end),dig)];
    end
    
end
end

ta=[ta(:,1:end),sepc2];
ta1=ta(1,:);

nc=size(ta1(ta1=='&'),2);
cl=['|c'];
for ii=1:nc
cl=[cl,'|c'];
end
cl=[cl,'|'];
dis=(strvcat('%\begin{table}[h]',...
      '\begin{center}'));
 
dis=strvcat(dis,(strvcat(['\begin{longtable}{', cl, '} '],...
    [' \caption{',caption,'}\label{}\\'])));

if doheader==1
dis=strvcat(dis,'\hline',head,'\\ \hline');
end

dis=strvcat(dis,'\hline\hline \endhead',...
 '\hline',...
'\endfoot');
dis=strvcat(dis,(ta));

dis=strvcat(dis,(' \end{longtable}'));
dis=strvcat(dis,(' \end{center}'));
dis=strvcat(dis,('% \end{table}'));
tabl=dis;
%disp(dis);
