%tableproducer
%function tabl=tabtex_highlight(header,caption,dig,highlight,cond1,cond2,varargin)
% this function prints on screen a LaTeX table which entries are
% (column-wise) the vectors in varargin. The input varargin are entries
% (e.g. vectors) separated by commas. At this point the vectors must have
% equal numbers of rows.
% if highlight is a vector of numbers,
% cond1 is a function to apply to the entries and to the vector highlight
% cond2 is an operator eg. == <= etc.
% G.L.

function tabl=tabtex_highlight(header,caption,dig,highlight,cond1,cond2,varargin)
%global ta
doheader=1;
tabl=[];
if size(highlight,2)>1;
    disp('fourth entry (highlight) must be an nx1 numerical matrix');
return
end
if isempty(header)
    doheader=0;
else
    head=[header(1,:)];
    
    for kk=2:size(header,1);
        head=[head,'&',header(kk,:)];
    end
end
if isempty(dig)
    dig=15;
end
ta=[];

hum=['& '
     '\\'];
 semc=[,
       ;];
   sepc1=[];
   sepc2=[];
   for uu=1:size(varargin{1},1)
       sepc1=[sepc1;hum(1,:)];
       sepc2=[sepc2;hum(2,:)];
   end
if ischar(varargin{1})
   ta=[strvcat(varargin{1}),sepc1];
elseif size(varargin{1},2)==1
    ta=[num2str(approx(varargin{1},dig)),sepc1];
else
    ta=[];
    for i=1:size(varargin{1},2)-1
        if i==1
        ta=[ta,[num2str(approx(varargin{1}(:,i),dig)),sepc1]];
        else
            if ~isempty(highlight)
                tmp=[];
                tmpo=[];
                for uu=1:size(varargin{1}(:,i),1);
  cond=eval([cond1,'(',num2str(varargin{1}(uu,i)),')',...
      cond2,cond1,'(',num2str(highlight(uu)),');']);
                    if cond
                    tmp=['\underline{',num2str(approx(varargin{1}(uu,i),dig)),'}'];
                    else
                    tmp=[num2str(approx(varargin{1}(uu,i),dig))];
                    end
                    tmpo=strvcat(tmpo,tmp);
                end
                ta=[ta,[tmpo,sepc1]];
            end
        end
    end
    tmp=[];
    tmpo=[];
    for uu=1:size(varargin{1}(:,i),1);
    cond=eval([cond1,'(',num2str(varargin{1}(uu,end)),')',...
      cond2,cond1,'(',num2str(highlight(uu)),');']);
                    if cond
                    tmp=['\underline{',num2str(approx(varargin{1}(uu,end),dig)),'}'];
                    else
                    tmp=[num2str(approx(varargin{1}(uu,end),dig))];
                    end
                    tmpo=strvcat(tmpo,tmp);
    end
                
    ta=[ta,tmpo];
end


if length(varargin)>1
    for i=2:length(varargin)
        if size(varargin{i},2)==1

            ta=[ta,[num2str(approx(varargin{i},dig))]];%,sepc1

        else
            for j=1:size(varargin{i},2)-1

                if j==1
                    ta=[ta,[num2str(approx(varargin{i}(:,j),dig)),sepc1]];
                else
                    if ~isempty(highlight)
                        tmp=[];
                        tmpo=[];
                        for uu=1:size(varargin{i}(:,j),1);
                            cond=eval([cond1,'(',num2str(varargin{i}(uu,j)),')',...
                                cond2,cond1,'(',num2str(highlight(uu)),');']);
                            if cond
                                tmp=['\underline{',num2str(approx(varargin{i}(uu,j),dig)),'}'];
                            else
                                tmp=[num2str(approx(varargin{i}(uu,j),dig))];
                            end
                            tmpo=strvcat(tmpo,tmp);
                        end
                        ta=[ta,[tmpo,sepc1]];
                    end
                end
            end
            tmp=[];
            tmpo=[];
            for uu=1:size(varargin{i}(:,j),1);
                cond=eval([cond1,'(',num2str(varargin{i}(uu,end)),')',...
                    cond2,cond1,'(',num2str(highlight(uu)),');']);
                if cond
                    tmp=['\underline{',num2str(approx(varargin{i}(uu,end),dig)),'}'];
                else
                    tmp=[num2str(approx(varargin{i}(uu,end),dig))];
                end
                tmpo=strvcat(tmpo,tmp);
            end

            ta=[ta,tmpo];
        end

    end
end

ta=[ta(:,1:end),sepc2];
ta1=ta(1,:);

nc=size(ta1(ta1=='&'),2);
cl=['|l'];
for ii=1:nc
cl=[cl,'|r'];
end
cl=[cl,'|'];
dis=(strvcat('%\begin{table}[h]',...
      '\begin{center}'));
 
dis=strvcat(dis,(strvcat(['\begin{longtable}{', cl, '} '],...
    [' \caption{',caption,'}\label{}\\'])));

if doheader==1
dis=strvcat(dis,'\hline',head,'\\ \hline');
end

dis=strvcat(dis,'\hline\hline \endhead',...
 '\hline',...
'\endfoot');
tao=[];
for jj=1:size(ta,1);
    tao=strvcat(tao,regexprep(ta(jj,:),'\& \(\)\(\)','\(\)\(\)'));
end
dis=strvcat(dis,(tao));
dis=strvcat(dis,' \hline');
dis=strvcat(dis,(' \end{longtable}'));
dis=strvcat(dis,(' \end{center}'));
dis=strvcat(dis,('% \end{table}'));
tabl=dis;
%disp(dis);