% this algorithm returns the indexes of the entries of a vec that
% correspond to the entries of the original matrix: e.g. if x is the
% col(row) entry of A, it returns the position in vec(A)
%%%%%%%%%%%%%%%%
% [ely,noely]=whereinvec(ely,n);
% input: ely=index vector of the searched elements
%        n = number of variables in the original square matrix
% output: ely= index of the vec vector that correspond to the input index       
%        
% example: look for the variables [1 8] in the vec(cov-matrix)

function [ely,noely]=whereinvec(ely,n);
%ely_old=ely; % keep memory of the ely entry
ely=ely(:);
%nk=length(indy); 
nn=n*(n);
ne=length(ely);
elynew=[];
% translate the entries in ely into the positioins of a vech transformation
% of the cross-product of n variables (to which indexes ely refers)
newely=[];
for jj=1:ne
newely=[newely;[ely(jj):n:nn,(ely(jj)-1)*n+1:(ely(jj))*n,(ely(jj))*n+ely(jj):n:nn]'];
end
ely=unique(newely);
noely=setdiff([1:nn]',newely);
