% this code returns the indexes that of the entries of a vech that
% correspond to the entries of the original matrix: e.g. if x is the
% col(row) entry of A, it returns the position in vech(A)
% input: ely=index vector of the searched elements
%        n = number of variables in the original square matrix
% output: ely= index of the vech vector that correspond to the input index       
%        
% example: look for the variables [1 8] in the vech(cov-matrix)

function [ely,noely]=whereinvech(ely,n);
%ely_old=ely; % keep memory of the ely entry
ely=ely(:);
%nk=length(indy); 
nn=n*(1+n)/2;
ne=length(ely);
elynew=[];
% translate the entries in ely into the positioins of a vech transformation
% of the cross-product of n variables (to which indexes ely refers)

for ww=1:ne % loop through ely
for ii=ely(ww)-1:n-1 % generate the new indexes
    elynew=[elynew;(ii+1)*ii/2+ely(ww)];
end
elynew=[elynew;(ely(ww)-1)*ely(ww)/2+[1:ely(ww)]'];
end

ely=unique(elynew); % redefine ely with the new indexation
noely=setdiff([1:nn]',ely);