* MMA05P23LSBYML.DO March 2005 for Stata version 8.0

log using mma05p3nlsbyml.txt, text replace

********** OVERVIEW OF MMA05P2NLSBYML.DO **********

* STATA Program 
* copyright C 2005 by A. Colin Cameron and Pravin K. Trivedi 
* used for "Microeconometrics: Methods and Applications" 
* by A. Colin Cameron and Pravin K. Trivedi (2005)
* Cambridge University Press 

* Chapter 5.9 pp.159-63  
* Nonlinear Least Squares using Stata command ml

* Provides third column of Table 5.7 for
*   (1) NLS     using Stata ml command (easy to get robust s.e.'s)
* using generated data set mma05data.asc

* Note: Use ml rather than nl as then much easier to get robust s.e.'s
*       Can instead use stata command nl see program mma05p2nlsbynl.do

* Related programs:
*   mma05p1mle.do          OLS and MLE for the same data 
*   mma05p2nls.do          NLS (and WMNLS and FGNLS) using Stata command nl
*   mma05p4margeffects.do  Calculates marginal effects     

* To run this program you need data and dictionary files
*    mma05data.asc    ASCII data set generated by mma05p1mle.do

********** SETUP **********

set more off
version 8

********** READ IN DATA and SUMMARIZE **********

* Model is  y ~ exponential(exp(a + bx))
*           x ~ N[mux, sigx^2]
*        f(y) = exp(a + bx)*exp(-y*exp(a + bx))
*      lnf(y) = (a + bx) - y*exp(a + bx)
*        E[y] = exp(-(a + bx))    note sign reversal for the mean
*        V[y] = exp(-(a + bx)) = E[y]^2
* Here a = 2, b = -1  and  x ~ N[mux=1, sigx^21]
* and Table 5.7 uses N=10,000 

* Data was generated by program mma05p1mle.do
infile y x using mma05data.asc

* Descriptive Statistics
describe
summarize

********** DO THE ANALYSIS: NLS using STATA COMMAND ML **********

* (1) NLS ESTIMATION USING STATA ML COMMAND (maximum likelihood)

* Advantage: ml command has robust standard errors as an option

* The NLS estimator minimizes SUM_i (y_i - g(x_i'b))^2.
* Here let g(x'b) = exp(a + b*x) = exp(b1int + b2x*x) say.
* In fact for this dgp  E[y] = exp(-(a + bx)) so sign reversal for the mean.

* To adjust this code to other NLS problems
* (a) If more regressors, say x1 x2 and x3, replace ml model line with
*        ml model lf mlexp (y = x1 x2 x3) / sigma
* (b) If different functional form for mean, say g(x'b), redefine `res' as
*        `res' = $ML_y1 - g(`theta')
* (c) If functional form for mean is not single-index then the program
*     will become considerably more complicated with more args.  

* (1A) The program "mlexp" defines the objective function
program define mlexp
  version 8.0
  args lnf theta sigma        /* theta contains b1int and b2x; sigma is st.dev.of error */
  tempvar res                 /* create to shorten expression for lnf */
  quietly gen double `res' = $ML_y1 - exp(-`theta')
  quietly replace `lnf' = -0.5*ln(2*_pi) - ln(`sigma') - 0.5*`res'^2/`sigma'^2
end

* (1B) The following command gives the dep variable (y) and regressors (x + intercept)
ml model lf mlexp (y = x) / sigma
ml search 
ml maximize
estimates store bnlsbymle

* (1C) Adding ,robust gives Heteroskedastic robust standard errors
ml model lf mlexp (y = x) / sigma, robust
ml search 
ml maximize
estimates store bnlsbymlerobust

***** PRINT RESULTS: Third column of Table 5.7 p.111 **********

* (1) NLS by ML - nonrobust and robust standard errors 
* The coefficient estimates are exactly the same as those using the nl command
* The estimated standard errors are close - within 10% of those using the nl command
* Table 5.7 reports the standard errors using the nl command
estimates table bnlsbymle bnlsbymlerobust, b(%10.4f) se(%10.4f) t stats(N ll)

********** CLOSE OUTPUT **********
log close
clear
exit
