* racd06p0.do  January 2012 for Stata version 12

capture log close
log using racd06p0.txt, text replace

********** OVERVIEW OF racd06p0.do **********

* STATA Program 
* copyright C 2013 by A. Colin Cameron and Pravin K. Trivedi 
* used for "Regression Analyis of Count Data" SECOND EDITION
* by A. Colin Cameron and Pravin K. Trivedi (2013)
* Cambridge University Press

* Chapter 6.1 only
*   6.1 INTRODUCTION: CREATE FIGURE 6.1

* To run you need files
*   racd06data1healthcare.dta
*   racd06data2rectrips.dta
*   racd06data3fertilityswiss.dta
*   racd06data4fertilitybritish
* in your directory

********** SETUP **********

set more off
version 11.2
clear all
* set linesize 82
set scheme s1mono  /* Graphics scheme */

********** DATA DESCRIPTION

* For the four datasets see 
*   racd06p1.do, racd06p2.do, racd06p3.do, racd06p4.do 
* for further details 

********** 6.1 INTRODUCTION: CREATE FIGURE 6.1

use racd06data1healthcare.dta, clear
label variable OFP "Office Visits to Physicians"
* The highest 1% are dropped for readability
histogram OFP if OFP < 30, discrete frequency barwidth(0.8) saving(racd06graph1, replace) xlabel(#6)
* histogram OFP, discrete frequency barwidth(0.8) saving(racd06graph1, replace) xlabel(#6)

use racd06data2rectrips, clear
label variable TRIPS "Recreational Boating Trips"
* The highest 1% are dropped for readability
histogram TRIPS if TRIPS < 30, discrete frequency barwidth(0.8) saving(racd06graph2, replace) xlabel(#6)

use racd06data3fertilityswiss.dta, clear
label variable children "Completed fertility: Swiss data"
histogram children, discrete frequency barwidth(0.8) saving(racd06graph3, replace) xlabel(#6)

use racd06data4fertilitybritish.dta, clear
label variable children "Completed fertility: British data"
histogram children, discrete frequency barwidth(0.8) saving(racd06graph4, replace) xlabel(#6)

*** FIGURE 6.1

graph combine racd06graph1.gph racd06graph2.gph racd06graph3.gph racd06graph4.gph, ///
   iscale(0.7) ysize(5) xsize(6) rows(2)

graph export racd06fig1.eps, replace
graph export racd06fig1.wmf, replace

********** CLOSE OUTPUT

* log close
* exit
* clear
