* racd09.do  January 2013 for Stata version 12

capture log close
log using racd09.txt, text replace

********** OVERVIEW OF racd09.do **********

* STATA Program 
* copyright C 2013 by A. Colin Cameron and Pravin K. Trivedi 
* used for "Regression Analyis of Count Data" SECOND EDITION
* by A. Colin Cameron and Pravin K. Trivedi (2013)
* Cambridge University Press

* This STATA program analyzes patent data for chapter 9
*   9.4 FIXED EFFECTS and POOLED (PA / GEE) ESTIMATORS
*   9.5 RANDOM EFFECTS ESTIMATORS
*   9.8 DYNAMIC MODELS WITH RANDOM and FIXED EFFECTS
* It provides much more detail than is in the book

* It takes a long time due to bootstraps to get panel robust se's
* In a couple of places bootstrap and jackknifes are commented out
* to speed up the program.
* In those cases the output is included as a comment.

* To run you need file
*   racd09data.dta
* in your directory

********** SETUP **********

set more off
version 12
clear all
* set linesize 82
set scheme s1mono  /* Graphics scheme */
* set maxvar 100 width 1000

********** DATA DESCRIPTION

*  The original data is from 
*  Bronwyn Hall, Zvi Griliches, and Jerry Hausman (1986), 
* "Patents and R&D: Is There a Lag?", 
*  International Economic Review, 27, 265-283.
* See this article for more detailed discussion 
* Also see racd09makedata.do for further details 

********** 9.4 PATENTS: READ DATA AND SUMMARIZE 

* This program gets clustered standard errors by bootstrap or jackknife
* when these are not provided by XT commands
* To speed up the program 
* 1. Drop vce(jackkife) where it appears (this has been done here)
* 2. Reduce BREPS from 400

global BREPS 400

use racd09data.dta, clear

*** TABLE 9.1: FREQUENCY DISTRIBUTION and SUMMARY STATISTICS for patents

generate PATRANGE =  PAT
recode PATRANGE (0=0) (1/5=1) (6/10=6) (11/20=11) (21/50=21) (51/100=51) (101/200=101) (201/515=201)
tabulate PATRANGE
summarize PAT, detail 

* Variable descriptions and summary statistics
describe
summarize

* Panel view
tsset
xtdescribe
xtsum PAT LOGR LOGR5 dyear2 dyear5 LOGK SCISECT 

* Serial correlation in PAT and LOGR
forvalues j = 1/4 {
     quietly corr PAT L`j'.PAT
     display "Autocorrelation at lag `j' = " %6.3f r(rho) 
     }
forvalues j = 1/4 {
     quietly corr LOGR L`j'.LOGR
     display "Autocorrelation at lag `j' = " %6.3f r(rho) 
     }

* First-order autocorrelation differs in different year pairs
forvalues s = 2/4 {
     quietly corr PAT L1.PAT if YEAR == `s'
     display "Autocorrelation at lag 1 in year `s' = " %6.3f r(rho) 
     }
forvalues s = 2/4 {
     quietly corr LOGR L1.LOGR if YEAR == `s'
     display "Autocorrelation at lag 1 in year `s' = " %6.3f r(rho) 
     }

by id: egen PATMEAN = mean(PAT)
generate PATDEV = PAT - PATMEAN
sort YEAR
summarize PATMEAN in 1/346, detail
bysort YEAR: sum PAT

sort id YEAR

********** ASIDE: CROSS SECTION MODELS 

global XLIST LOGR LOGR1 LOGR2 LOGR3 LOGR4 LOGR5 LOGK SCISECT dyear2 dyear3 dyear4 dyear5
* global XLIST LOGR LOGR1 LOGR2 LOGR3 LOGR4 LOGR5 dyear2 dyear3 dyear4 dyear5 LOGK SCISECT
global XLISTTIMEVARYING LOGR LOGR1 LOGR2 LOGR3 LOGR4 LOGR5 dyear2 dyear3 dyear4 dyear5

* Serial correlation in residuals
quietly poisson PAT $XLIST
predict poissrawresid, score
forvalues j = 1/4 {
     quietly corr poissrawresid L`j'.poissrawresid
     display "Autocorrelation at lag `j' = " %6.3f r(rho) 
     }
forvalues s = 2/4 {
     quietly corr poissrawresid L1.poissrawresid if YEAR == `s'
     display "Autocorrelation at lag 1 in year `s' = " %6.3f r(rho) 
     }

* Serial correlation in residuals
quietly poisson PAT $XLIST i.id
predict poissrawresid2, score
forvalues j = 1/4 {
     quietly corr poissrawresid2 L`j'.poissrawresid2
     display "Autocorrelation at lag `j' = " %6.3f r(rho) 
     }
forvalues s = 2/4 {
     quietly corr poissrawresid2 L1.poissrawresid2 if YEAR == `s'
     display "Autocorrelation at lag 1 in year `s' = " %6.3f r(rho) 
     }

* Poisson Cross-section
quietly poisson PAT $XLIST
estimates store PCSdef
quietly poisson PAT $XLIST, vce(robust)
estimates store PCSrob
* Following standard errors are preferred
quietly poisson PAT $XLIST, vce(cluster id)
estimates store PCSclu
display "Table 9.2: first column Sum ln R"
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5

* Negative binomial NB2 Cross-section
quietly nbreg PAT $XLIST
estimates store NBCSdef
quietly nbreg PAT $XLIST, vce(robust)
estimates store NBCSrob
* Following standard errors are preferred
quietly nbreg PAT $XLIST, vce(cluster id)
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
estimates store NBCSclu

estimates table PCSdef PCSrob PCSclu NBCSdef NBCSrob NBCSclu, b(%7.4f) se(%7.3f) stats(N ll) 

********* 9.4 POPULATION AVERAGED MODELS

* Poisson GEE exchangeable
quietly xtgee PAT $XLIST, family(poisson) corr(exch)
estimates store PPAEXdef
* Following standard errors are preferred
xtgee PAT $XLIST, family(poisson) corr(exch) vce(robust)
estimates store PPAEXrob
display "Table 9.2: second column Sum ln R"
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
* Poisson GEE AR(1) errors
quietly xtgee PAT $XLIST, family(poisson) corr(ar1) vce(robust)
estimates store PPAARrob

* Negative binomial
* Here we need to give the value of alpha - use the cross-section nbreg estimate
* Furthermore needs to be done manually (can't use alpha where scalar alpha = e(alpha))
quietly nbreg PAT $XLIST
scalar alpha = e(alpha)
display "The correct alpha to use is: " alpha
* NB2 GEE exchangeable errors errors
xtgee PAT $XLIST, family(nbinomial .7785956) corr(exch)
estimates store NBPAEXdef
* Following standard errors are preferred
xtgee PAT $XLIST, family(nbinomial .7785956) corr(exch) vce(robust)
estimates store NBPAEXrob
* NB2 GEE AR(1) errors
xtgee PAT $XLIST, family(nbinomial .7785956) corr(ar1) vce(robust)
estimates store NBPAARrob

estimates table PPAEXdef PPAEXrob PPAARrob NBPAEXdef NBPAEXrob NBPAARrob, b(%7.4f) se(%7.3f) stats(N ll)

********** 9.4 FIXED EFFECTS MODELS

* Poisson fixed effects
quietly xtpoisson PAT $XLIST, fe
estimates store PFEdef
* Following standard errors are preferred
xtpoisson PAT $XLIST, fe vce(robust)
estimates store PFErob
display "Table 9.2: third column Sum ln R"
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5

* Following checks with a jackknife
* xtpoisson PAT $XLIST, fe vce(jackknife)
* estimates store PFEjack
* Dummy variables - gives same estimates and almost same standard errors
* poisson PAT $XLIST i.id, vce(cluster id)
* estimates store PFEDVclu

* Negative binomial fixed effects
quietly xtnbreg PAT $XLIST, fe
estimates store NBFEdef
* Following takes a while - may want to comment out
* xtnbreg PAT $XLIST, fe vce(jacknife)   // Jackknife as no vce(robust) here
* estimates store NBFEjack
display "Table 9.2: fourth column Sum ln R"
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
* Dummy variables - gives different estimates
* nbreg PAT $XLIST i.id, vce(cluster id) dispersion(constant)
* estimates store NBFEDVclu

estimates table PFEdef PFErob NBFEdef, b(%7.4f) se(%7.3f) stats(N ll) equations(1)

/*  . xtnbreg PAT $XLIST, fe vce(jacknife)   // Jackknife as no vce(robust) here
(running xtnbreg on estimation sample)

Jackknife replications (324)
----+--- 1 ---+--- 2 ---+--- 3 ---+--- 4 ---+--- 5 
..................................................    50
..................................................   100
..................................................   150
..................................................   200
..................................................   250
..................................................   300
........................
Conditional FE negative binomial regression     Number of obs      =      1620
Group variable: id                              Number of groups   =       324

                                                Obs per group: min =         5
                                                               avg =       5.0
                                                               max =         5

                                                F(    12,     323) =      6.96
Log likelihood  = -3203.0644                    Prob > F           =    0.0000

                                    (Replications based on 324 clusters in id)
------------------------------------------------------------------------------
             |              Jackknife
         PAT |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        LOGR |    .272679   .0801407     3.40   0.001     .1150154    .4303426
       LOGR1 |  -.0978866   .0795833    -1.23   0.220    -.2544537    .0586804
       LOGR2 |   .0320762   .0604324     0.53   0.596    -.0868146     .150967
       LOGR3 |  -.0203923    .072151    -0.28   0.778    -.1623375     .121553
       LOGR4 |   .0162214   .0625026     0.26   0.795    -.1067422     .139185
       LOGR5 |   -.009728   .0663792    -0.15   0.884    -.1403181    .1208621
        LOGK |   .2071488   .1029215     2.01   0.045     .0046676      .40963
     SCISECT |   .0176397   .3264891     0.05   0.957    -.6246739    .6599533
      dyear2 |  -.0383927   .0179525    -2.14   0.033    -.0737113    -.003074
      dyear3 |  -.0399403   .0253008    -1.58   0.115    -.0897155    .0098349
      dyear4 |  -.1443278   .0319978    -4.51   0.000    -.2072783   -.0813773
      dyear5 |  -.1957518   .0339705    -5.76   0.000    -.2625832   -.1289204
       _cons |   1.661392   .5358439     3.10   0.002     .6072074    2.715577
------------------------------------------------------------------------------
. estimates store NBFEjack

. lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
 ( 1)  [PAT]LOGR + [PAT]LOGR1 + [PAT]LOGR2 + [PAT]LOGR3 + [PAT]LOGR4 + [PAT]LOGR5 = 0
------------------------------------------------------------------------------
         PAT |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
         (1) |   .1929697   .1136149     1.70   0.090    -.0305488    .4164883
------------------------------------------------------------------------------

*/

*** TABLE 9.2: POOLED POISSON, POOLED GEE, POISSON FE, NB1 FE

* Note: Following gives default se's for NB1FE and not jackknife se's (given above)
estimates table PCSclu PPAEXrob PFErob NBFEdef, b(%11.4f) se(%11.3f) stats(N ll) equations(1)

********** 9.5 RANDOM EFFECTS MODELS

* There is no robust option for , re so need to bootstrap

* Poisson - gamma random effects
xtpoisson PAT $XLIST, re
estimates store PREdef
* Following standard errors are preferred
xtpoisson PAT $XLIST, re vce(boot, reps($BREPS) seed(10101))
display "Table 9.3: first column Sum ln R"
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
estimates store PRErob

* Poisson - normal random effects
xtpoisson PAT $XLIST, re normal
estimates store PRENdef
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
* Following standard errors are preferred
* This took a long time so is comment out
* xtpoisson PAT $XLIST, re normal vce(jackknife)
* estimates store PRENrob
* display "Table 9.3: second column Sum ln R"
* lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
* or ..
* Note that about 20% of bootstrap replications failed to estimate
* xtpoisson PAT $XLIST, re normal vce(boot, reps($BREPS) seed(10101))
* lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5

/* JACKKNIFE
. xtpoisson PAT $XLIST, re normal vce(jackknife)
(running xtpoisson on estimation sample)
Jackknife replications (346)
----+--- 1 ---+--- 2 ---+--- 3 ---+--- 4 ---+--- 5 
..................................................    50
..................................................   100
...x..............................................   150
..................................................   200
..................................................   250
..................................................   300
..............................................
Random-effects Poisson regression               Number of obs      =      1730
Group variable: id                              Number of groups   =       346
Random effects u_i ~ Gaussian                   Obs per group: min =         5
                                                               avg =       5.0
                                                               max =         5
                                                F(    12,     344) =     94.88
Log likelihood  = -5245.0127                    Prob > F           =    0.0000
                                    (Replications based on 346 clusters in id)
------------------------------------------------------------------------------
             |              Jackknife
         PAT |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        LOGR |   .4153326   .0781077     5.32   0.000     .2617038    .5689614
       LOGR1 |  -.0403106   .0744648    -0.54   0.589    -.1867743    .1061531
       LOGR2 |    .112102   .0649979     1.72   0.085    -.0157413    .2399453
       LOGR3 |   .0348424   .0886451     0.39   0.695    -.1395122     .209197
       LOGR4 |   .0126664   .0669306     0.19   0.850    -.1189783     .144311
       LOGR5 |   .0471076   .0794252     0.59   0.553    -.1091126    .2033278
        LOGK |   .2917346   .0834706     3.50   0.001     .1275577    .4559115
     SCISECT |    .443509   .1527652     2.90   0.004     .1430375    .7439805
      dyear2 |  -.0453001   .0180533    -2.51   0.013    -.0808088   -.0097914
      dyear3 |  -.0496512   .0270002    -1.84   0.067    -.1027575     .003455
      dyear4 |  -.1766992   .0398763    -4.43   0.000    -.2551313   -.0982671
      dyear5 |  -.2301051   .0389316    -5.91   0.000     -.306679   -.1535312
       _cons |  -.1513461   .2729969    -0.55   0.580    -.6882993    .3856072
-------------+----------------------------------------------------------------
    /lnsig2u |  -.0052583   .1107198    -0.05   0.962    -.2230313    .2125146
-------------+----------------------------------------------------------------
     sigma_u |   .9973743   .0552145                      .8944774    1.112108
------------------------------------------------------------------------------
Likelihood-ratio test of sigma_u=0: chibar2(01) =  2.5e+04 Pr>=chibar2 = 0.000
. lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
 ( 1)  [PAT]LOGR + [PAT]LOGR1 + [PAT]LOGR2 + [PAT]LOGR3 + [PAT]LOGR4 + [PAT]LOGR5 = 0
------------------------------------------------------------------------------
         PAT |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
         (1) |   .5817403   .0977223     5.95   0.000     .3895319    .7739487
------------------------------------------------------------------------------
*/

/* BOOTSTRAP FOR POISSON RE NORMAL FAILED MANY TIMES
. xtpoisson PAT $XLIST, re normal vce(boot, reps($BREPS) seed(10101))
(running xtpoisson on estimation sample)
Bootstrap replications (400)
----+--- 1 ---+--- 2 ---+--- 3 ---+--- 4 ---+--- 5 
x...x..x..xx..x.xx....x...........x.............x.    50
......x...x......x.x.xx.xx..x...x.....x....x.x....   100
.x...................x.....x...x..x....x..x.......   150
..............x........x...x..x..........x...x....   200
.........x.......x....x...x...xx..xxx.....xx....x.   250
xx.x.........x.x.x........x............x........x.   300
.x.....x....................x.x..........x.....x.x   350
x.........x..x...x.....x........x.....x...........   400
Random-effects Poisson regression               Number of obs      =      1730
Group variable: id                              Number of groups   =       346
Random effects u_i ~ Gaussian                   Obs per group: min =         5
                                                               avg =       5.0
                                                               max =         5
                                                Wald chi2(12)      =   1202.83
Log likelihood  = -5245.0127                    Prob > chi2        =    0.0000
                                    (Replications based on 346 clusters in id)
------------------------------------------------------------------------------
             |   Observed   Bootstrap                         Normal-based
         PAT |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        LOGR |   .4153326   .0816933     5.08   0.000     .2552166    .5754485
       LOGR1 |  -.0403106   .0779906    -0.52   0.605    -.1931694    .1125482
       LOGR2 |    .112102   .0632054     1.77   0.076    -.0117782    .2359822
       LOGR3 |   .0348424   .0842935     0.41   0.679    -.1303698    .2000546
       LOGR4 |   .0126664    .066196     0.19   0.848    -.1170754    .1424082
       LOGR5 |   .0471076   .0728772     0.65   0.518     -.095729    .1899442
        LOGK |   .2917346   .0782631     3.73   0.000     .1383418    .4451274
     SCISECT |    .443509   .1454438     3.05   0.002     .1584444    .7285735
      dyear2 |  -.0453001   .0181748    -2.49   0.013    -.0809221   -.0096781
      dyear3 |  -.0496512   .0274114    -1.81   0.070    -.1033767    .0040742
      dyear4 |  -.1766992   .0383587    -4.61   0.000     -.251881   -.1015175
      dyear5 |  -.2301051   .0379868    -6.06   0.000    -.3045579   -.1556523
       _cons |  -.1513461   .2651781    -0.57   0.568    -.6710856    .3683935
-------------+----------------------------------------------------------------
    /lnsig2u |  -.0052583    .120223    -0.04   0.965     -.240891    .2303744
-------------+----------------------------------------------------------------
     sigma_u |   .9973743   .0599537                      .8865254    1.122083
------------------------------------------------------------------------------
Likelihood-ratio test of sigma_u=0: chibar2(01) =  2.5e+04 Pr>=chibar2 = 0.000
. estimates store PRENrob
. display "Table 9.3: second column Sum ln R"
Table 9.3: second column Sum ln R
. lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
 ( 1)  [PAT]LOGR + [PAT]LOGR1 + [PAT]LOGR2 + [PAT]LOGR3 + [PAT]LOGR4 + [PAT]LOGR5 = 0
------------------------------------------------------------------------------
         PAT |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
         (1) |   .5817403   .0909148     6.40   0.000     .4035506      .75993
------------------------------------------------------------------------------
*/

/* SO INSTEAD PANEL JACKKNIFE FOR POISSON RE NORMAL
   THESE ARE THE STANDARD ERRORS IN TABLE 9.3 FOR POISSON RE NORMAL
. xtpoisson PAT $XLIST, re normal vce(jackknife)
(running xtpoisson on estimation sample)
Jackknife replications (346)
----+--- 1 ---+--- 2 ---+--- 3 ---+--- 4 ---+--- 5 
..................................................    50
..................................................   100
...x..............................................   150
..................................................   200
..................................................   250
..................................................   300
..............................................
Random-effects Poisson regression               Number of obs      =      1730
Group variable: id                              Number of groups   =       346

Random effects u_i ~ Gaussian                   Obs per group: min =         5
                                                               avg =       5.0
                                                               max =         5
                                                F(    12,     344) =     94.88
Log likelihood  = -5245.0127                    Prob > F           =    0.0000
                                    (Replications based on 346 clusters in id)
------------------------------------------------------------------------------
             |              Jackknife
         PAT |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        LOGR |   .4153326   .0781077     5.32   0.000     .2617038    .5689614
       LOGR1 |  -.0403106   .0744648    -0.54   0.589    -.1867743    .1061531
       LOGR2 |    .112102   .0649979     1.72   0.085    -.0157413    .2399453
       LOGR3 |   .0348424   .0886451     0.39   0.695    -.1395122     .209197
       LOGR4 |   .0126664   .0669306     0.19   0.850    -.1189783     .144311
       LOGR5 |   .0471076   .0794252     0.59   0.553    -.1091126    .2033278
        LOGK |   .2917346   .0834706     3.50   0.001     .1275577    .4559115
     SCISECT |    .443509   .1527652     2.90   0.004     .1430375    .7439805
      dyear2 |  -.0453001   .0180533    -2.51   0.013    -.0808088   -.0097914
      dyear3 |  -.0496512   .0270002    -1.84   0.067    -.1027575     .003455
      dyear4 |  -.1766992   .0398763    -4.43   0.000    -.2551313   -.0982671
      dyear5 |  -.2301051   .0389316    -5.91   0.000     -.306679   -.1535312
       _cons |  -.1513461   .2729969    -0.55   0.580    -.6882993    .3856072
-------------+----------------------------------------------------------------
    /lnsig2u |  -.0052583   .1107198    -0.05   0.962    -.2230313    .2125146
-------------+----------------------------------------------------------------
     sigma_u |   .9973743   .0552145                      .8944774    1.112108
------------------------------------------------------------------------------
Likelihood-ratio test of sigma_u=0: chibar2(01) =  2.5e+04 Pr>=chibar2 = 0.000

. lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
 ( 1)  [PAT]LOGR + [PAT]LOGR1 + [PAT]LOGR2 + [PAT]LOGR3 + [PAT]LOGR4 + [PAT]LOGR5 = 0

------------------------------------------------------------------------------
         PAT |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
         (1) |   .5817403   .0977223     5.95   0.000     .3895319    .7739487
------------------------------------------------------------------------------
*/

* Negative binomial - beta distributed ratio random effects
xtnbreg PAT $XLIST, re
estimates store NBREdef
* Following standard errors are preferred
xtnbreg PAT $XLIST, re vce(boot, reps($BREPS) seed(10101))
estimates store NBRErob
display "Table 9.3: third column Sum ln R"
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5
* There is no RE normal option for xtnbreg

estimates table PREdef PRErob PRENdef NBREdef NBRErob, b(%11.4f) se(%11.3f) stats(N ll)

* Conditionally Correlated Random Effects
sort id
by id: egen LOGRMEAN = mean(LOGR)
by id: egen LOGR1MEAN = mean(LOGR1)
by id: egen LOGR2MEAN = mean(LOGR2)
by id: egen LOGR3MEAN = mean(LOGR3)
by id: egen LOGR4MEAN = mean(LOGR4)
by id: egen LOGR5MEAN = mean(LOGR5)
global MEANS LOGRMEAN LOGR1MEAN LOGR2MEAN LOGR3MEAN LOGR4MEAN LOGR5MEAN

* Poisson CCRE 
xtpoisson PAT $XLIST $MEANS, re
estimates store PCCREdef
* Following standard errors are preferred
xtpoisson PAT $XLIST $MEANS, re vce(boot, reps($BREPS) seed(10101))
estimates store PCCRErob
display "Table 9.3: fourth column Sum ln R"
lincom LOGR + LOGR1 + LOGR2 + LOGR3 + LOGR4 + LOGR5

*** TABLE 9.3: RANDOM EFFECTS - Poisson-gamma, Poisson-normal, NB, CCRE
* For Poisson RE - normal default se's given here to speed up program
* See the panel kackknife above for correct se's
estimates table PRErob PRENdef NBRErob PCCRErob, b(%11.4f) se(%11.3f) stats(N ll)

********* DYNAMIC MODELS USING EXPONENTIAL FEEDBACK MODEL

* Add PAT lagged once as regressor
* And now have just two lags of LOGR as regressors
global XLISTD PAT1 LOGR LOGR1 LOGR2 LOGK SCISECT dyear2 dyear3 dyear4 dyear5

* Pooled Poisson
poisson PAT $XLISTD, vce(cluster id)
estimates store DPCS
display "Table 9.5: first column Sum ln R"
lincom LOGR + LOGR1 + LOGR2

* Population Averaged Poisson with exchangeable errors
* Following standard errors are preferred
xtpoisson PAT $XLISTD, pa vce(robust)
display "Table 9.5: second column Sum ln R"
lincom LOGR + LOGR1 + LOGR2

* Poisson Random Effects - gamma
estimates store DPPA
xtpoisson PAT $XLISTD, re vce(boot, reps($BREPS) seed(10101))
estimates store DPRE
display "Table 9.5: third column Sum ln R"
lincom LOGR + LOGR1 + LOGR2

generate PAT_YEAR0 = PAT1 if YEAR==1    // = PAT1 in YEAR 1 and missing in YEARS 1-5
bysort id: egen PAT_INITIAL = mean(PAT_YEAR0)  // Replaces missings with PAT1 in YEAR1

global XLISTD2 PAT1 LOGR LOGR1 LOGR2 LOGK SCISECT PAT_INITIAL LOGRMEAN LOGR1MEAN LOGR2MEAN dyear2 dyear3 dyear4 dyear5 

* Correlated random effects versions of the same
* Cross-section Poisson
poisson PAT $XLISTD2, vce(cluster id)
estimates store DPCS2
* Population averaged Poisson with exchangeable errrors
xtpoisson PAT $XLISTD2, pa vce(robust)
estimates store DPPA2

* Poisson Random Effects - gamma
xtpoisson PAT $XLISTD2, re vce(boot, reps($BREPS) seed(10101))
estimates store DPCCRE
display "Table 9.6: first column Sum ln R"
lincom LOGR + LOGR1 + LOGR2

estimates table DPCS DPCS2 DPPA DPPA2 DPRE DPCCRE, b(%7.4f) se(%7.3f) stats(N ll) stfmt(%9.1f) modelwidth(9) equations(1)

* Fixed effects GMM using Chamberlain transformation
* This program is the same as gmm_poipre in Stata manual [r]gmm
program gmm_poipre
   version 11
   syntax varlist if, at(name) myrhs(varlist) ///
   mylhs(varlist) myidvar(varlist)
   quietly {
   tempvar mu mubar ybar
   gen double `mu' = 0 `if'
   local j = 1
   foreach var of varlist `myrhs' {
      replace `mu' = `mu' + `var'*`at'[1,`j'] `if'
      local j = `j' + 1
      }
   replace `mu' = exp(`mu')
   replace `varlist' = L.`mylhs' - L.`mu'*`mylhs'/`mu' `if'
   }
end

* Only include time-varying regressors
* Also here year 1 is dropped, so drop the year 2 dummy
* Regressors 
global XLISTTV PAT1 LOGR LOGR1 LOGR2 dyear3 dyear4 dyear5
* Instruments in just-identified case
global IVLISTTV PAT2 LOGR1 LOGR2 LOGR3 dyear3 dyear4 dyear5
* Instruments in over-identified case
global IVLISTTV2 PAT2 PAT3 PAT4 LOGR1 LOGR2 LOGR3 dyear3 dyear4 dyear5

* Just-identified
gmm gmm_poipre, mylhs(PAT) myrhs($XLISTTV) myidvar(id) nequations(1) ///
   parameters($XLISTTV) instruments($IVLISTTV, noconstant) onestep vce(cluster id)
estimates store DPGMM

* Overidentified
gmm gmm_poipre, mylhs(PAT) myrhs($XLISTTV) myidvar(id) nequations(1) ///
  parameters($XLISTTV) instruments($IVLISTTV2, noconstant) twostep vce(cluster id)
estimates store DPGMMOID
display "Table 9.6: second column Sum ln R"
lincom _b[LOGR:_cons]+_b[LOGR1:_cons]+_b[LOGR2:_cons]
estat overid
predict residGMM
correlate residGMM L.residGMM L2.residGMM

*** CHECK: THIS DOES POISSON FE USING GMM COMMAND

* This program is the same as gmm_poi in Stata manual [r]gmm
program gmm_poi2
   version 11
   syntax varlist if, at(name) myrhs(varlist) ///
   mylhs(varlist) myidvar(varlist)
   quietly {
   tempvar mu mubar ybar
   gen double `mu' = 0 `if'
   local j = 1
   foreach var of varlist `myrhs' {
      replace `mu' = `mu' + `var'*`at'[1,`j'] `if'
      local j = `j' + 1
      }
   replace `mu' = exp(`mu')
   egen double `mubar' = mean(`mu') `if', by(`myidvar')
   egen double `ybar' = mean(`mylhs') `if', by(`myidvar')
   replace `varlist' = `mylhs' - `mu'*`ybar'/`mubar' `if'
   }
end
gmm gmm_poi2, mylhs(PAT) myrhs($XLISTTIMEVARYING)          ///
 myidvar(id) nequations(1) parameters($XLISTTIMEVARYING)   ///
 instruments($XLISTTIMEVARYING, noconstant) onestep vce(cluster id)
estimates store PFEGMM
 
************** CROSS-SECTION SUMMARY

estimates table PCSdef PCSrob PCSclu NBCSdef NBCSrob NBCSclu, b(%7.4f) se(%7.3f) stats(N ll) stfmt(%9.1f) modelwidth(9)  

************** POPULATION AVERAGED SUMMARY

estimates table PPAEXdef PPAEXrob PPAARrob NBPAEXdef NBPAEXrob NBPAARrob, b(%7.4f) se(%7.3f) stats(N ll) stfmt(%9.1f) modelwidth(9)

* estimates table PCSdef PCSrob PCSclu PAdef PArob, b(%7.4f) se stats(N ll) star(0.05, 0.01, 0.001) equations(1) stfmt(%9.1f) modelwidth(9)

************** FIXED EFFECTS SUMMARY

estimates table PFEdef PFErob NBFEdef, b(%7.4f) se stats(N ll) equations(1) stfmt(%9.1f) modelwidth(9)

************** RANDOM EFFECTS SUMMARY

estimates table PREdef PRErob PRENdef NBREdef NBRErob, b(%7.4f) se(%7.3f) stats(N ll) stfmt(%9.1f) modelwidth(9)

************** COMBINED RESULTS SUMMARY

* Poisson
estimates table PCSclu PPAEXrob PRErob PFErob, b(%7.4f) se(%7.3f) stats(N ll) equations(1) stfmt(%9.1f) modelwidth(9)

* Negative binomial
estimates table NBCSclu NBPAEXrob NBRErob NBFEdef, b(%7.4f) se(%7.3f) stats(N ll) equations(1) stfmt(%9.1f) modelwidth(9)

* Poisson versus negative binomial 1
estimates table PCSclu NBCSclu PPAEXrob NBPAEXrob, b(%7.4f) se(%7.3f) stats(N ll) equations(1) stfmt(%9.1f) modelwidth(9)

* Poisson versus negative binomial 2
estimates table PRErob NBRErob PFEdef NBFEdef, b(%7.4f) se(%7.3f) stats(N ll) equations(1) stfmt(%9.1f) modelwidth(9)

************** TABLES in the BOOK

*** TABLE 9.2: POOLED POISSON, POOLED GEE, POISSON FE, NB1 FE
* Note: Following gives default se's for NB1FE and not jackknife se's (given above)
estimates table PCSclu PPAEXrob PFErob NBFEdef, b(%7.4f) se(%7.3f) stats(N ll) stfmt(%9.1f) modelwidth(9) equations(1)

*** TABLE 9.3: RANDOM EFFECTS - Poisson-gamma, Poisson-normal, NB, CCRE
* For Poisson RE - normal default se's given here to speed up program (jackknife given above)
estimates table PRErob PRENdef NBRErob PCCRErob, b(%7.4f) se(%7.3f) stats(N ll) stfmt(%9.1f) modelwidth(9) equations(1)

*** TABLE 9.5 and first column TABLE 9.6: DYNAMIC MODELS RANDOM EFFECTS AND CCRE
estimates table DPCS DPPA DPRE DPCCRE, b(%7.4f) se(%7.3f) stats(N ll) stfmt(%9.1f) modelwidth(9) equations(1)

*** TABLE 9.6: DYNAMIC MODELS FIXED EFFECTS 
* Second column as first column given with TABLE 9.5 results 
estimates table DPGMMOID, b(%7.4f) se(%7.3f) stats(N ll) stfmt(%9.1f) modelwidth(9)

********** CLOSE OUTPUT

* log close
* clear
* exit
